<?php
class installerPts {
	static public $update_to_version_method = '';
	static private $_firstTimeActivated = false;
	static public function init() {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		$current_version = get_option($wpPrefix. PTS_DB_PREF. 'db_version', 0);
		if(!$current_version)
			self::$_firstTimeActivated = true;
		/**
		 * modules 
		 */
		//dbPts::query("DROP TABLE @__modules");
		if (!dbPts::exist("@__modules")) {
			dbDelta(dbPts::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `code` varchar(32) NOT NULL,
			  `active` tinyint(1) NOT NULL DEFAULT '0',
			  `type_id` tinyint(1) NOT NULL DEFAULT '0',
			  `label` varchar(64) DEFAULT NULL,
			  `ex_plug_dir` varchar(255) DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  UNIQUE INDEX `code` (`code`)
			) DEFAULT CHARSET=utf8;"));
			dbPts::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES
				(NULL, 'adminmenu',1,1,'Admin Menu'),
				(NULL, 'options',1,1,'Options'),
				(NULL, 'user',1,1,'Users'),
				(NULL, 'pages',1,1,'Pages'),
				(NULL, 'templates',1,1,'templates'),
				(NULL, 'supsystic_promo',1,1,'supsystic_promo'),
				(NULL, 'admin_nav',1,1,'admin_nav'),
				(NULL, 'mail',1,1,'mail'),
				
				(NULL, 'tables',1,1,'tables');");
		}
		/**
		 *  modules_type 
		 */
		if(!dbPts::exist("@__modules_type")) {
			dbDelta(dbPts::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules_type` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `label` varchar(32) NOT NULL,
			  PRIMARY KEY (`id`)
			) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;"));
			dbPts::query("INSERT INTO `@__modules_type` VALUES
				(1,'system'),
				(6,'addons');");
		}
		if (!dbPts::exist("@__tables")) {
			dbDelta(dbPts::prepareQuery("CREATE TABLE IF NOT EXISTS `@__tables` (
				`id` INT(11) NOT NULL AUTO_INCREMENT,
				`unique_id` varchar(8) NOT NULL,
				`label` varchar(128) NOT NULL,
				`original_id` INT(11) NOT NULL DEFAULT '0',
				`params` TEXT NOT NULL,
				`html` MEDIUMTEXT NOT NULL,
				`css` TEXT NOT NULL,
				`img` varchar(64) DEFAULT NULL,
				`sort_order` MEDIUMINT(5) NOT NULL DEFAULT '0',
				`is_base` TINYINT(1) NOT NULL DEFAULT '1',
				`is_pro`  TINYINT(1) NOT NULL DEFAULT '0',
				`date_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;"));
		}
		if(!dbPts::exist("@__tables", "is_pro")) {
			dbPts::query("ALTER TABLE `@__tables` ADD COLUMN `is_pro` TINYINT(1) NOT NULL DEFAULT '0';");
		}

		if (version_compare($current_version, '1.2.5') != 1)
			dbPts::query("ALTER TABLE `@__tables` MODIFY html MEDIUMTEXT;");
		
		self::initBaseTables();
		/**
		* Plugin usage statistics
		*/
		if(!dbPts::exist("@__usage_stat")) {
			dbDelta(dbPts::prepareQuery("CREATE TABLE `@__usage_stat` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `code` varchar(64) NOT NULL,
			  `visits` int(11) NOT NULL DEFAULT '0',
			  `spent_time` int(11) NOT NULL DEFAULT '0',
			  `modify_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
			  UNIQUE INDEX `code` (`code`),
			  PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8"));
			dbPts::query("INSERT INTO `@__usage_stat` (code, visits) VALUES ('installed', 1)");
		}
		installerDbUpdaterPts::runUpdate();
		if($current_version && !self::$_firstTimeActivated) {
			self::setUsed();
		}
		update_option($wpPrefix. PTS_DB_PREF. 'db_version', PTS_VERSION);
		add_option($wpPrefix. PTS_DB_PREF. 'db_installed', 1);
	}
	static public function setUsed() {
		update_option(PTS_DB_PREF. 'plug_was_used', 1);
	}
	static public function isUsed() {
		// No welcome page for now
		return true;
		return (int) get_option(PTS_DB_PREF. 'plug_was_used');
	}
	static public function delete() {
		self::_checkSendStat('delete');
		global $wpdb;
		$wpPrefix = $wpdb->prefix;
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PTS_DB_PREF."modules`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PTS_DB_PREF."modules_type`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PTS_DB_PREF."usage_stat`");
		delete_option($wpPrefix. PTS_DB_PREF. 'db_version');
		delete_option($wpPrefix. PTS_DB_PREF. 'db_installed');
	}
	static public function deactivate() {
		self::_checkSendStat('deactivate');
	}
	static private function _checkSendStat($statCode) {
		if(class_exists('framePts') 
			&& framePts::_()->getModule('supsystic_promo')
			&& framePts::_()->getModule('options')
		) {
			framePts::_()->getModule('supsystic_promo')->getModel()->saveUsageStat( $statCode );
			framePts::_()->getModule('supsystic_promo')->getModel()->checkAndSend( true );
		}
	}
	static public function update() {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		$currentVersion = get_option($wpPrefix. PTS_DB_PREF. 'db_version', 0);
		if(!$currentVersion || version_compare(PTS_VERSION, $currentVersion, '>')) {
			self::init();
			update_option($wpPrefix. PTS_DB_PREF. 'db_version', PTS_VERSION);
		}
	}
	static public function initBaseTables() {
		// TODO: Remove this after some time will pass
		dbPts::query('DELETE FROM @__tables WHERE original_id = 0 AND is_base = 1 and (unique_id = "" OR unique_id IS NULL)');
		$data = array(
//'sbleUq5P' => array('unique_id' => 'sbleUq5P','label' => 'Transparent Description','original_id' => '0','params' => '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','html' => '<div class=\"ptsContainer\">\r\n	<div class=\"ptsColsWrapper\">\r\n		{% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n		<div class=\"ptsEl ptsCol ptsCol-0 ptsTableDescCol ptsElWithArea\" data-el=\"table_col_desc\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\" style=\"height: 69px;\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\" style=\"height: 141px;\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">choose <span style=\"color: rgb(59, 214, 255);\" data-mce-style=\"color: #853a3a;\">your</span> plan</span></p></div>\r\n				</div>\r\n				<div class=\"ptsRows\" style=\"height: 224px;\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Amount of space</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Bandwidth per month</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">E-mail accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">MySql databases</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">24h support</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\" style=\"height: 51px;\"></div>\r\n			</div>\r\n		</div>\r\n		{% endif %}\r\n		<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">starter</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">10</span></span></p><p><span data-mce-style=\"font-size: 12pt;\" style=\"font-size: 12pt;\">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">10GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">100GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">1</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">1</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(214, 71, 71)\" data-icon=\"fa-minus-square-o\">\r\n							<i style=\"color: rgb(214, 71, 71)\" class=\"fa fa-minus-square-o fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-2 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">econom</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">30</span></span></p><p><span data-mce-style=\"font-size: 12pt;\" style=\"font-size: 12pt;\">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">30GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">300GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">3</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">3</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(22, 173, 255)\" data-icon=\"fa-check-square-o\">\r\n							<i style=\"color: rgb(22, 173, 255)\" class=\"fa fa-check-square-o fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">standard</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">59</span></span></p><p><span data-mce-style=\"font-size: 12pt;\" style=\"font-size: 12pt;\">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">100GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">5</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">5</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(22, 173, 255)\" data-icon=\"fa-check-square-o\">\r\n							<i style=\"color: rgb(22, 173, 255)\" class=\"fa fa-check-square-o fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-4 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">pro</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">99</span></span></p><p><span data-mce-style=\"font-size: 12pt;\" style=\"font-size: 12pt;\">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">1000GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(22, 173, 255)\" data-icon=\"fa-check-square-o\">\r\n							<i style=\"color: rgb(22, 173, 255)\" class=\"fa fa-check-square-o fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n	<div style=\"clear: both;\"></div>\r\n</div>','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  	{% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n  		width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n  	{% else%}\r\n  		width: {{ 100 / table.params.cols_num.val }}%;\r\n  	{% endif %}\r\n  {% else%}\r\n	width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n  transition: box-shadow 0.25 ease 0;\r\n}\r\n#{{table.view_id}} .ptsColHeader,\r\n#{{table.view_id}} .ptsColDesc {\r\n	padding: 10px;\r\n}\r\n#{{table.view_id}} p {\r\n	margin: 0;\r\n}\r\n#{{table.view_id}} .ptsCell,\r\n#{{table.view_id}} .ptsColFooter {\r\n	padding: 10px 0;\r\n}\r\n#{{table.view_id}} .ptsColHeader {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -10) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n  background-image: linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ table.params.bg_color.val }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -23) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ table.params.bg_color.val }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -23) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* IE9 */\r\n  background: -moz-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ table.params.bg_color.val }}), color-stop(1, {{ adjBs(table.params.bg_color.val, -23) }})); /* Chrome 10, Safari */\r\n  \r\n  	border-bottom: 1px solid {{ adjBs(table.params.bg_color.val, -40) }};\r\n}\r\n#{{table.view_id}} .ptsColDesc {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -10) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n  background-image: linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, -15) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -40) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, -15) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -40) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* IE9 */\r\n  background: -moz-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ adjBs(table.params.bg_color.val, -15) }}), color-stop(1, {{ adjBs(table.params.bg_color.val, -40) }})); /* Chrome 10, Safari */\r\n  	border-top: 1px solid {{ adjBs(table.params.bg_color.val, 5) }};\r\n}\r\n#{{table.view_id}} .ptsCell:nth-child(odd) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 165) }};\r\n}\r\n#{{table.view_id}} .ptsCell:nth-child(even) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 195) }};\r\n}\r\n#{{table.view_id}} .ptsCol:nth-child(odd) .ptsCell:nth-child(odd) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 145) }};\r\n}\r\n#{{table.view_id}} .ptsCol:nth-child(odd) .ptsCell:nth-child(even) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 165) }};\r\n}\r\n#{{table.view_id}} .ptsColFooter {\r\n 	background-color: {{ adjBs(table.params.bg_color.val, 130) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n	background-image: linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 160) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 100) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 160) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 100) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* IE9 */\r\n	background: -moz-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ adjBs(table.params.bg_color.val, 160) }}), color-stop(1, {{ adjBs(table.params.bg_color.val, 100) }})); /* Chrome 10, Safari */\r\n  \r\n	border-top: 1px solid {{ adjBs(table.params.bg_color.val, 145) }};\r\n}\r\n#{{table.view_id}} .ptsActBtn {\r\n	display: inline-block;\r\n  	padding: 4px 20px;\r\n  	border: 1px solid {{ adjBs(table.params.bg_color.val, 85) }};\r\n  	width: 80%;\r\n  	border-radius: 3px;\r\n}\r\n#{{table.view_id}} .ptsActBtn:hover {\r\n	 background-color: {{ adjBs(table.params.bg_color.val, 110) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n	background-image: linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 140) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 80) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 140) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 80) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* IE9 */\r\n	background: -moz-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ adjBs(table.params.bg_color.val, 140) }}), color-stop(1, {{ adjBs(table.params.bg_color.val, 80) }})); /* Chrome 10, Safari */\r\n  \r\n}\r\n#{{table.view_id}} .ptsActBtn .ptsEditArea  {\r\n  	font-size: 10pt; \r\n  	font-weight: bold;\r\n  	text-decoration: none !important;\r\n  	border: none !important;\r\n	width: 100%;\r\n}\r\n#{{table.view_id}} .ptsCol:first-of-type .ptsColHeader {\r\n	border-top-left-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol:last-of-type .ptsColHeader {\r\n	border-top-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol:first-of-type .ptsColFooter {\r\n	border-bottom-left-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol:last-of-type .ptsColFooter {\r\n	border-bottom-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n  	display: none;\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n	transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n  	-webkit-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -moz-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -ms-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -o-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n	z-index: 101;\r\n  	box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n	-moz-box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n	margin-top: -20px;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsColHeader {\r\n	border-top-left-radius: 5px;\r\n  	border-top-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsColFooter {\r\n	border-bottom-left-radius: 5px;\r\n  	border-bottom-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColHeader,\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColDesc {\r\n	background: transparent none repeat scroll 0 0;\r\n  	border-color: transparent;\r\n}\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColFooter {\r\n	border-radius: 0;\r\n}\r\n/*Colors set*/\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n  	color: {{table.params.text_color.val}};\r\n}\r\n','img' => 'transparent-description.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-08-25 22:34:41','is_pro' => '0'),
'RQjyfqVX' => array('unique_id' => 'RQjyfqVX','label' => 'Rainbow','original_id' => '0','params' => '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','html' => '<div class=\"ptsContainer\">\r\n	<div class=\"ptsColsWrapper\">\r\n		{% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n		<div class=\"ptsEl ptsCol ptsCol-0 ptsTableDescCol ptsElWithArea\" data-el=\"table_col_desc\" data-color=\"#f5f5f5\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p></p></div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Free Trial</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Projects</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">SSL</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Storage</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Sub-domains</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\"></div>\r\n			</div>\r\n		</div>\r\n		{% endif %}\r\n		<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-color=\"rgb(51, 153, 255)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">SINGLE LICENSE</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">$29</span></p><p><span style=\"\">ONE TIME FEE</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">10 user accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Free 30-day trial</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">200 projects</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">No encryption</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">100 MB Storage</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">10 custom domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">100 sub domains</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">Sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-2 ptsElWithArea\" data-color=\"rgb(147, 194, 48)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">DEVELOPER LICENSE</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">$49</span></p><p><span style=\"\">ONE TIME FEE</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">100 user accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Free 30-day trial</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500 projects</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">SSL encryption</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">1000 MB Storage</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">100 custom domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500 sub domains</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">Sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-color=\"rgb(255, 174, 53)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">PREMIUM LICENSE</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">$99</span></p><p><span style=\"\">ONE TIME FEE</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500 user accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Free 30-day trial</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited projects</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">SSL encryption</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">5000 MB Storage</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500 custom domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">1000 sub domains</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">Sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-4 ptsElWithArea\" data-color=\"rgb(240, 61, 0)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">ENTERPRISE LICENSE</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">$199</span></p><p><span style=\"\">ONE TIME FEE</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">1000 user accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Free 30-day trial</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited projects</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">SSL encryption</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited Storage</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited custom domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Unlimited sub domains</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">Sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n	<div style=\"clear: both;\"></div>\r\n</div>','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  	{% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n  		width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n  	{% else%}\r\n  		width: {{ 100 / table.params.cols_num.val }}%;\r\n  	{% endif %}\r\n  {% else%}\r\n	width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n  \r\n  padding: 0 10px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent .ptsRows {\r\n 	background-color: {{ table.params.bg_color.val }};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n	padding: 15px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n	padding: 30px 15px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n  	border: 1px solid {{ adjBs(table.params.bg_color.val, -35) }};\r\n  	border-top-width: 0;\r\n  	border-bottom-width: 0;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsCell {\r\n	padding: 12px;\r\n  	border-bottom: 1px solid {{ adjBs(table.params.bg_color.val, -35) }};\r\n  	border-top: 1px solid #fff;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsCell:last-of-type {\r\n	border-bottom: none;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColFooter {\r\n	padding: 20px;\r\n  	border: 1px solid {{ adjBs(table.params.bg_color.val, -35) }};\r\n  	background-image: linear-gradient(to bottom, {{adjBs(table.params.bg_color.val, 20)}}, {{adjBs(table.params.bg_color.val, -20)}});\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn {\r\n	width: 100%;\r\n  	border-radius: 3px;\r\n  	cursor: pointer;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn .ptsEditArea {\r\n	font-size: 1.4em;\r\n  	width: 100%;\r\n  	padding: 10px 0;\r\n  	text-decoration: none !important;\r\n  	border: none !important;\r\n}\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n  	display: none;\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColHeader,\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColDesc,\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColFooter {\r\n	visibility: hidden;\r\n}\r\n#{{table.view_id}} p {\r\n	margin: 0;\r\n}\r\n/*Animations*/\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n	transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n  	-webkit-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -moz-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -ms-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -o-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n	z-index: 101;\r\n  	box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	-moz-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	margin-top: -20px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn:hover {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -35) }};\r\n}#{{table.view_id}} span, #{{table.view_id}} p {\r\n	word-break: break-word;\r\n}\r\n/*Colors set*/\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n  	color: {{table.params.text_color.val}};\r\n}\r\n/*start for col color 1*/\r\n#{{table.view_id}} .ptsCol-1 .ptsColHeader {\r\n	background-color: rgb(51, 153, 255);\r\n}\r\n#{{table.view_id}} .ptsCol-1 .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-1 .ptsActBtn:hover {\r\n	background-color: #1076dc;\r\n}\r\n#{{table.view_id}} .ptsCol-1 .ptsActBtn {\r\n	background-color: rgb(51, 153, 255);\r\n}\r\n/*end for col color 1*/\r\n/*start for col color 2*/\r\n#{{table.view_id}} .ptsCol-2 .ptsColHeader {\r\n	background-color: rgb(147, 194, 48);\r\n}\r\n#{{table.view_id}} .ptsCol-2 .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-2 .ptsActBtn:hover {\r\n	background-color: #709f0d;\r\n}\r\n#{{table.view_id}} .ptsCol-2 .ptsActBtn {\r\n	background-color: rgb(147, 194, 48);\r\n}\r\n/*end for col color 2*//*start for col color 3*/\r\n#{{table.view_id}} .ptsCol-3 .ptsColHeader {\r\n	background-color: rgb(255, 174, 53);\r\n}\r\n#{{table.view_id}} .ptsCol-3 .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-3 .ptsActBtn:hover {\r\n	background-color: #dc8b12;\r\n}\r\n#{{table.view_id}} .ptsCol-3 .ptsActBtn {\r\n	background-color: rgb(255, 174, 53);\r\n}\r\n/*end for col color 3*//*start for col color 4*/\r\n#{{table.view_id}} .ptsCol-4 .ptsColHeader {\r\n	background-color: rgb(240, 61, 0);\r\n}\r\n#{{table.view_id}} .ptsCol-4 .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-4 .ptsActBtn:hover {\r\n	background-color: #cd1a00;\r\n}\r\n#{{table.view_id}} .ptsCol-4 .ptsActBtn {\r\n	background-color: rgb(240, 61, 0);\r\n}\r\n/*end for col color 4*/\r\n','img' => 'rainbow.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-08-26 16:32:53','is_pro' => '0'),
'pnNjNRm5' => array('unique_id' => 'pnNjNRm5','label' => 'Flat Table','original_id' => '0','params' => 'YToxOTp7czo4OiJiZ19jb2xvciI7YToxOntzOjM6InZhbCI7czo3OiIjNDljNmUxIjt9czoxNDoiY2VsbF9jb2xvcl9jc3MiO2E6MTp7czozOiJ2YWwiO3M6NTIwOiIje3t0YWJsZS52aWV3X2lkfX0gLnB0c0NvbC17e2VsLm51bX19IC5wdHNUYWJsZUVsZW1lbnRDb250ZW50IHsNCgliYWNrZ3JvdW5kLWNvbG9yOiB7e2VsLmNvbG9yfX07DQp9DQoje3t0YWJsZS52aWV3X2lkfX0gLnB0c0NvbC17e2VsLm51bX19IC5wdHNUYWJsZUVsZW1lbnRDb250ZW50IC5wdHNDb2xEZXNjLA0KI3t7dGFibGUudmlld19pZH19IC5wdHNDb2wte3tlbC5udW19fSAucHRzVGFibGVFbGVtZW50Q29udGVudCAucHRzQWN0QnRuLA0KI3t7dGFibGUudmlld19pZH19IC5wdHNDb2wte3tlbC5udW19fSAucHRzVGFibGVFbGVtZW50Q29udGVudCAucHRzUm93cyAucHRzQ2VsbDpob3ZlciAgew0KCWJhY2tncm91bmQtY29sb3I6IHt7YWRqQnMoZWwuY29sb3IsIDIwKX19Ow0KfQ0KI3t7dGFibGUudmlld19pZH19IC5wdHNDb2wte3tlbC5udW19fSAucHRzVGFibGVFbGVtZW50Q29udGVudCAucHRzQWN0QnRuOmhvdmVyIHsNCgliYWNrZ3JvdW5kLWNvbG9yOiB7e2FkakJzKGVsLmNvbG9yLCAtMjApfX07DQp9Ijt9czoxMjoiZW5iX2Rlc2NfY29sIjthOjE6e3M6MzoidmFsIjtzOjE6IjAiO31zOjk6ImNvbF93aWR0aCI7YToxOntzOjM6InZhbCI7czozOiIxODYiO31zOjg6ImNvbHNfbnVtIjthOjE6e3M6MzoidmFsIjtzOjE6IjMiO31zOjg6InJvd3NfbnVtIjthOjE6e3M6MzoidmFsIjtzOjE6IjciO31zOjEwOiJjYWxjX3dpZHRoIjthOjE6e3M6MzoidmFsIjtzOjU6InRhYmxlIjt9czoxMToidGFibGVfd2lkdGgiO2E6MTp7czozOiJ2YWwiO3M6MzoiMTAwIjt9czoxOToidGFibGVfd2lkdGhfbWVhc3VyZSI7YToxOntzOjM6InZhbCI7czoxOiIlIjt9czoxOToiZW5iX2hvdmVyX2FuaW1hdGlvbiI7YToxOntzOjM6InZhbCI7czoxOiIxIjt9czoxMzoidHh0X2l0ZW1faHRtbCI7YToxOntzOjM6InZhbCI7czoxNjQ6IjxkaXYgY2xhc3M9XCJwdHNFbFwiIGRhdGEtZWw9XCJ0YWJsZV9jZWxsX3R4dFwiIGRhdGEtdHlwZT1cInR4dFwiPjxwPjxzcGFuIHN0eWxlPVwiZm9udC1zaXplOiAxOHB0O1wiIGRhdGEtbWNlLXN0eWxlPVwiZm9udC1zaXplOiAxOHB0O1wiPllvdXIgVGV4dDwvc3Bhbj48L3A+PC9kaXY+Ijt9czoxMzoiaW1nX2l0ZW1faHRtbCI7YToxOntzOjM6InZhbCI7czoxNzg6IjxkaXYgY2xhc3M9XCJwdHNFbCBwdHNFbEltZyBwdHNFbFdpdGhBcmVhXCIgZGF0YS1lbD1cInRhYmxlX2NlbGxfaW1nXCIgZGF0YS10eXBlPVwiaW1nXCI+DQoJPGRpdiBjbGFzcz1cInB0c0VsQXJlYVwiPjxpbWcgc3JjPVwiW1BUU19BU1NFVFNfVVJMXWltZy9leGFtcGxlLmpwZ1wiIC8+PC9kaXY+DQo8L2Rpdj4iO31zOjE0OiJpY29uX2l0ZW1faHRtbCI7YToxOntzOjM6InZhbCI7czoyMjg6IjxkaXYgZGF0YS1pY29uPVwiZmEtY29nXCIgZGF0YS1jb2xvcj1cInJnYigwLCAyMjAsIDIyMylcIiBkYXRhLXR5cGU9XCJpY29uXCIgZGF0YS1lbD1cInRhYmxlX2NlbGxfaWNvblwiIGNsYXNzPVwicHRzSWNvbiBwdHNFbCBwdHNFbElucHV0XCI+PGkgY2xhc3M9XCJmYSBmYS0yeCBwdHNJbnB1dFNoZWxsIGZhLWNvZ1wiIHN0eWxlPVwiY29sb3I6IHJnYigwLCAyMjAsIDIyMyk7XCI+PC9pPjwvZGl2PiI7fXM6MTM6Im5ld19jZWxsX2h0bWwiO2E6MTp7czozOiJ2YWwiO3M6NDY0OiI8ZGl2IGNsYXNzPVwicHRzQ2VsbFwiPg0KCTxkaXYgY2xhc3M9XCJwdHNJY29uIHB0c0VsIHB0c0VsSW5wdXRcIiBkYXRhLWVsPVwidGFibGVfY2VsbF9pY29uXCIgZGF0YS10eXBlPVwiaWNvblwiIGRhdGEtY29sb3I9XCJyZ2IoMjU1LCAyNTUsIDI1NSlcIiBkYXRhLWljb249XCJmYS1jaGVjay1jaXJjbGVcIj4NCgkJPGkgc3R5bGU9XCJjb2xvcjogcmdiKDI1NSwgMjU1LCAyNTUpXCIgY2xhc3M9XCJmYSBmYS0yeCBmYS1jaGVjay1jaXJjbGUgcHRzSW5wdXRTaGVsbFwiPjwvaT4NCgk8L2Rpdj4NCgk8ZGl2IGNsYXNzPVwicHRzRWxcIiBkYXRhLWVsPVwidGFibGVfY2VsbF90eHRcIiBkYXRhLXR5cGU9XCJ0eHRcIj4NCgkJPHA+PHNwYW4gc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCIgZGF0YS1tY2Utc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCI+WW91ciBUZXh0PC9zcGFuPjwvcD4NCgk8L2Rpdj4NCjwvZGl2PiI7fXM6MTU6Im5ld19jb2x1bW5faHRtbCI7YToxOntzOjM6InZhbCI7czo0NzM3OiI8ZGl2IGNsYXNzPVwicHRzRWwgcHRzQ29sIHB0c0VsV2l0aEFyZWFcIiBkYXRhLWNvbG9yPVwicmdiKDIzMSwgNzYsIDYwKVwiIGRhdGEtZWw9XCJ0YWJsZV9jb2xcIiBkYXRhLWVuYi1jb2xvcj1cIjFcIj4NCgk8ZGl2IGNsYXNzPVwicHRzVGFibGVFbGVtZW50Q29udGVudCBwdHNFbEFyZWFcIj4NCgkJPGRpdiBjbGFzcz1cInB0c0NvbEhlYWRlclwiPg0KCQkJPGRpdiBjbGFzcz1cInB0c0VsXCIgZGF0YS1lbD1cInRhYmxlX2NlbGxfdHh0XCIgZGF0YS10eXBlPVwidHh0XCI+DQoJCQkJPHA+PHNwYW4gc3R5bGU9XCJmb250LXNpemU6IDI0cHQ7XCIgZGF0YS1tY2Utc3R5bGU9XCJmb250LXNpemU6IDI0cHQ7XCI+U1RVREVOVDwvc3Bhbj48L3A+DQoJCQkJPHA+PHNwYW4gc3R5bGU9XCJmb250LXNpemU6IDE0cHQ7XCIgZGF0YS1tY2Utc3R5bGU9XCJmb250LXNpemU6IDE0cHQ7XCI+Rm9yIHRoZSBCZWdpbm5lcjwvc3Bhbj48L3A+DQoJCQk8L2Rpdj4NCgkJPC9kaXY+DQoJCTxkaXYgY2xhc3M9XCJwdHNSb3dzXCI+DQoJCQk8ZGl2IGNsYXNzPVwicHRzQ2VsbFwiPg0KCQkJCTxkaXYgY2xhc3M9XCJwdHNJY29uIHB0c0VsIHB0c0VsSW5wdXRcIiBkYXRhLWVsPVwidGFibGVfY2VsbF9pY29uXCIgZGF0YS10eXBlPVwiaWNvblwiIGRhdGEtY29sb3I9XCJyZ2IoMjU1LCAyNTUsIDI1NSlcIiBkYXRhLWljb249XCJmYS1jaGVjay1jaXJjbGVcIj4NCgkJCQkJPGkgc3R5bGU9XCJjb2xvcjogcmdiKDI1NSwgMjU1LCAyNTUpXCIgY2xhc3M9XCJmYSBmYS0yeCBmYS1jaGVjay1jaXJjbGUgcHRzSW5wdXRTaGVsbFwiPjwvaT4NCgkJCQk8L2Rpdj4NCgkJCQk8ZGl2IGNsYXNzPVwicHRzRWxcIiBkYXRhLWVsPVwidGFibGVfY2VsbF90eHRcIiBkYXRhLXR5cGU9XCJ0eHRcIj4NCgkJCQkJPHA+PHNwYW4gc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCIgZGF0YS1tY2Utc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCI+MSBHQiBEaXNrIFNwYWNlPC9zcGFuPjwvcD4NCgkJCQk8L2Rpdj4NCgkJCTwvZGl2Pg0KCQkJPGRpdiBjbGFzcz1cInB0c0NlbGxcIj4NCgkJCQk8ZGl2IGNsYXNzPVwicHRzSWNvbiBwdHNFbCBwdHNFbElucHV0XCIgZGF0YS1lbD1cInRhYmxlX2NlbGxfaWNvblwiIGRhdGEtdHlwZT1cImljb25cIiBkYXRhLWNvbG9yPVwicmdiKDI1NSwgMjU1LCAyNTUpXCIgZGF0YS1pY29uPVwiZmEtY2hlY2stY2lyY2xlXCI+DQoJCQkJCTxpIHN0eWxlPVwiY29sb3I6IHJnYigyNTUsIDI1NSwgMjU1KVwiIGNsYXNzPVwiZmEgZmEtMnggZmEtY2hlY2stY2lyY2xlIHB0c0lucHV0U2hlbGxcIj48L2k+DQoJCQkJPC9kaXY+DQoJCQkJPGRpdiBjbGFzcz1cInB0c0VsXCIgZGF0YS1lbD1cInRhYmxlX2NlbGxfdHh0XCIgZGF0YS10eXBlPVwidHh0XCI+DQoJCQkJCTxwPjxzcGFuIHN0eWxlPVwiZm9udC1zaXplOiAxOHB0O1wiIGRhdGEtbWNlLXN0eWxlPVwiZm9udC1zaXplOiAxOHB0O1wiPjIgRGF0YWJhc2VzPC9zcGFuPjwvcD4NCgkJCQk8L2Rpdj4NCgkJCTwvZGl2Pg0KCQkJPGRpdiBjbGFzcz1cInB0c0NlbGxcIj4NCgkJCQk8ZGl2IGNsYXNzPVwicHRzSWNvbiBwdHNFbCBwdHNFbElucHV0XCIgZGF0YS1lbD1cInRhYmxlX2NlbGxfaWNvblwiIGRhdGEtdHlwZT1cImljb25cIiBkYXRhLWNvbG9yPVwicmdiKDI1NSwgMjU1LCAyNTUpXCIgZGF0YS1pY29uPVwiZmEtdGltZXMtY2lyY2xlXCI+DQoJCQkJCTxpIHN0eWxlPVwiY29sb3I6IHJnYigyNTUsIDI1NSwgMjU1KVwiIGNsYXNzPVwiZmEgZmEtMnggZmEtdGltZXMtY2lyY2xlIHB0c0lucHV0U2hlbGxcIj48L2k+DQoJCQkJPC9kaXY+DQoJCQkJPGRpdiBjbGFzcz1cInB0c0VsXCIgZGF0YS1lbD1cInRhYmxlX2NlbGxfdHh0XCIgZGF0YS10eXBlPVwidHh0XCI+DQoJCQkJCTxwPjxzcGFuIHN0eWxlPVwiZm9udC1zaXplOiAxOHB0O1wiIGRhdGEtbWNlLXN0eWxlPVwiZm9udC1zaXplOiAxOHB0O1wiPk5vIERvbWFpbnM8L3NwYW4+PC9wPg0KCQkJCTwvZGl2Pg0KCQkJPC9kaXY+DQoJCQk8ZGl2IGNsYXNzPVwicHRzQ2VsbFwiPg0KCQkJCTxkaXYgY2xhc3M9XCJwdHNJY29uIHB0c0VsIHB0c0VsSW5wdXRcIiBkYXRhLWVsPVwidGFibGVfY2VsbF9pY29uXCIgZGF0YS10eXBlPVwiaWNvblwiIGRhdGEtY29sb3I9XCJyZ2IoMjU1LCAyNTUsIDI1NSlcIiBkYXRhLWljb249XCJmYS1jaGVjay1jaXJjbGVcIj4NCgkJCQkJPGkgc3R5bGU9XCJjb2xvcjogcmdiKDI1NSwgMjU1LCAyNTUpXCIgY2xhc3M9XCJmYSBmYS0yeCBmYS1jaGVjay1jaXJjbGUgcHRzSW5wdXRTaGVsbFwiPjwvaT4NCgkJCQk8L2Rpdj4NCgkJCQk8ZGl2IGNsYXNzPVwicHRzRWxcIiBkYXRhLWVsPVwidGFibGVfY2VsbF90eHRcIiBkYXRhLXR5cGU9XCJ0eHRcIj4NCgkJCQkJPHA+PHNwYW4gc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCIgZGF0YS1tY2Utc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCI+NSBVc2Vyczwvc3Bhbj48L3A+DQoJCQkJPC9kaXY+DQoJCQk8L2Rpdj4NCgkJCTxkaXYgY2xhc3M9XCJwdHNDZWxsXCI+DQoJCQkJPGRpdiBjbGFzcz1cInB0c0ljb24gcHRzRWwgcHRzRWxJbnB1dFwiIGRhdGEtZWw9XCJ0YWJsZV9jZWxsX2ljb25cIiBkYXRhLXR5cGU9XCJpY29uXCIgZGF0YS1jb2xvcj1cInJnYigyNTUsIDI1NSwgMjU1KVwiIGRhdGEtaWNvbj1cImZhLWNoZWNrLWNpcmNsZVwiPg0KCQkJCQk8aSBzdHlsZT1cImNvbG9yOiByZ2IoMjU1LCAyNTUsIDI1NSlcIiBjbGFzcz1cImZhIGZhLTJ4IGZhLWNoZWNrLWNpcmNsZSBwdHNJbnB1dFNoZWxsXCI+PC9pPg0KCQkJCTwvZGl2Pg0KCQkJCTxkaXYgY2xhc3M9XCJwdHNFbFwiIGRhdGEtZWw9XCJ0YWJsZV9jZWxsX3R4dFwiIGRhdGEtdHlwZT1cInR4dFwiPg0KCQkJCQk8cD48c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTogMThwdDtcIiBkYXRhLW1jZS1zdHlsZT1cImZvbnQtc2l6ZTogMThwdDtcIj4xMCBFbWFpbCBBY2NvdW50czwvc3Bhbj48L3A+DQoJCQkJPC9kaXY+DQoJCQk8L2Rpdj4NCgkJCTxkaXYgY2xhc3M9XCJwdHNDZWxsXCI+DQoJCQkJPGRpdiBjbGFzcz1cInB0c0ljb24gcHRzRWwgcHRzRWxJbnB1dFwiIGRhdGEtZWw9XCJ0YWJsZV9jZWxsX2ljb25cIiBkYXRhLXR5cGU9XCJpY29uXCIgZGF0YS1jb2xvcj1cInJnYigyNTUsIDI1NSwgMjU1KVwiIGRhdGEtaWNvbj1cImZhLWNoZWNrLWNpcmNsZVwiPg0KCQkJCQk8aSBzdHlsZT1cImNvbG9yOiByZ2IoMjU1LCAyNTUsIDI1NSlcIiBjbGFzcz1cImZhIGZhLTJ4IGZhLWNoZWNrLWNpcmNsZSBwdHNJbnB1dFNoZWxsXCI+PC9pPg0KCQkJCTwvZGl2Pg0KCQkJCTxkaXYgY2xhc3M9XCJwdHNFbFwiIGRhdGEtZWw9XCJ0YWJsZV9jZWxsX3R4dFwiIGRhdGEtdHlwZT1cInR4dFwiPg0KCQkJCQk8cD48c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTogMThwdDtcIiBkYXRhLW1jZS1zdHlsZT1cImZvbnQtc2l6ZTogMThwdDtcIj4xMCBHQiBCYW5kd2lkdGg8L3NwYW4+PC9wPg0KCQkJCTwvZGl2Pg0KCQkJPC9kaXY+DQoJCQk8ZGl2IGNsYXNzPVwicHRzQ2VsbFwiPg0KCQkJCTxkaXYgY2xhc3M9XCJwdHNJY29uIHB0c0VsIHB0c0VsSW5wdXRcIiBkYXRhLWVsPVwidGFibGVfY2VsbF9pY29uXCIgZGF0YS10eXBlPVwiaWNvblwiIGRhdGEtY29sb3I9XCJyZ2IoMjU1LCAyNTUsIDI1NSlcIiBkYXRhLWljb249XCJmYS1jaGVjay1jaXJjbGVcIj4NCgkJCQkJPGkgc3R5bGU9XCJjb2xvcjogcmdiKDI1NSwgMjU1LCAyNTUpXCIgY2xhc3M9XCJmYSBmYS0yeCBmYS1jaGVjay1jaXJjbGUgcHRzSW5wdXRTaGVsbFwiPjwvaT4NCgkJCQk8L2Rpdj4NCgkJCQk8ZGl2IGNsYXNzPVwicHRzRWxcIiBkYXRhLWVsPVwidGFibGVfY2VsbF90eHRcIiBkYXRhLXR5cGU9XCJ0eHRcIj4NCgkJCQkJPHA+PHNwYW4gc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCIgZGF0YS1tY2Utc3R5bGU9XCJmb250LXNpemU6IDE4cHQ7XCI+MjQvNyBDdXN0b21lciBTdXBwb3J0PC9zcGFuPjwvcD4NCgkJCQk8L2Rpdj4NCgkJCTwvZGl2Pg0KCQk8L2Rpdj4NCgkJPGRpdiBjbGFzcz1cInB0c0NvbERlc2NcIj4NCgkJCTxkaXYgY2xhc3M9XCJwdHNFbFwiIGRhdGEtZWw9XCJ0YWJsZV9jZWxsX3R4dFwiIGRhdGEtdHlwZT1cInR4dFwiPg0KCQkJCTxwPjxzcGFuIGRhdGEtbWNlLXN0eWxlPVwiZm9udC1zaXplOiAzNnB0O1wiIHN0eWxlPVwiZm9udC1zaXplOiAzNnB0O1wiPiQ8c3BhbiBkYXRhLW1jZS1zdHlsZT1cImZvbnQtc2l6ZTogNDhwdDtcIiBzdHlsZT1cImZvbnQtc2l6ZTogNDhwdDtcIj4zNTk8L3NwYW4+Ljk5PC9zcGFuPjwvcD48cD48c3BhbiBkYXRhLW1jZS1zdHlsZT1cImZvbnQtc2l6ZTogMTRwdDtcIiBzdHlsZT1cImZvbnQtc2l6ZTogMTRwdDtcIj5Nb250aGx5IFBsYW48L3NwYW4+PGJyPjwvcD4NCgkJCTwvZGl2Pg0KCQk8L2Rpdj4NCgkJPGRpdiBjbGFzcz1cInB0c0NvbEZvb3RlclwiPg0KCQkJPGRpdiBjbGFzcz1cInB0c0FjdEJ0biBwdHNFbCBwdHNFbElucHV0XCIgZGF0YS1lbD1cImJ0blwiIGRhdGEtYmdjb2xvci10bz1cInR4dFwiIGRhdGEtYmdjb2xvcj1cIiNmZmZcIiBkYXRhLWJnY29sb3ItZWxlbWVudHM9XCIucHRzRWRpdEFyZWFcIj4NCgkJCQk8YSB0YXJnZXQ9XCJfYmxhbmtcIiBocmVmPVwiaHR0cHM6Ly9zdXBzeXN0aWMuY29tL1wiIGNsYXNzPVwicHRzRWRpdEFyZWEgcHRzSW5wdXRTaGVsbFwiIHN0eWxlPVwiY29sb3I6ICNmZmY7XCI+U0lHTiBVUCBOT1c8L2E+DQoJCQk8L2Rpdj4NCgkJPC9kaXY+DQoJPC9kaXY+DQo8L2Rpdj4iO31zOjExOiJmb250X2ZhbWlseSI7YToxOntzOjM6InZhbCI7czoxNjoiUm9ib3RvIENvbmRlbnNlZCI7fXM6MTA6InRleHRfY29sb3IiO2E6MTp7czozOiJ2YWwiO3M6NDoiI2ZmZiI7fXM6MTc6InRleHRfY29sb3JfaGVhZGVyIjthOjE6e3M6MzoidmFsIjtzOjQ6IiNmZmYiO31zOjE1OiJ0ZXh0X2NvbG9yX2Rlc2MiO2E6MTp7czozOiJ2YWwiO3M6NDoiI2ZmZiI7fX0=','html' => '<div class=\"ptsContainer\">\r\n	<div class=\"ptsColsWrapper\">\r\n		{% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n		<div class=\"ptsEl ptsCol ptsCol-0 ptsTableDescCol ptsElWithArea\"  data-color=\"#49c6e1\" data-el=\"table_col_desc\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span style=\"font-size: 24pt;\" data-mce-style=\"font-size: 24pt;\">CHOOSE</span></p>\r\n						<p><span style=\"font-size: 14pt;\" data-mce-style=\"font-size: 14pt;\">Your Plan</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Disk Space</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Databases</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Users</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Email Accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Bandwidth</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Support</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">Price<br></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\"></div>\r\n			</div>\r\n		</div>\r\n		{% endif %}\r\n		<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-color=\"rgb(231, 76, 60)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span style=\"font-size: 24pt;\" data-mce-style=\"font-size: 24pt;\">STUDENT</span></p>\r\n						<p><span style=\"font-size: 14pt;\" data-mce-style=\"font-size: 14pt;\">For the Beginner</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">1 GB Disk Space</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">2 Databases</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-times-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-times-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">No Domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">5 Users</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">10 Email Accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">10 GB Bandwidth</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">24/7 Customer Support</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">$<span data-mce-style=\"font-size: 48pt;\" style=\"font-size: 48pt;\">359</span>.99</span></p><p><span style=\"font-family: tahoma,arial,helvetica,sans-serif;\" data-mce-style=\"font-family: tahoma,arial,helvetica,sans-serif;\"><span data-mce-style=\"font-size: 14pt;\" style=\"font-size: 14pt;\">Monthly Plan</span><br></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">SIGN UP NOW</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-2 ptsElWithArea\" data-color=\"#9b59b6\" data-el=\"table_col\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span style=\"font-size: 24pt;\" data-mce-style=\"font-size: 24pt;\">UNLIMITED</span></p>\r\n						<p><span style=\"font-size: 14pt;\" data-mce-style=\"font-size: 14pt;\">For the Unlimited Users</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">1 GB Disk Space</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">2 Databases</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-times-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-times-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">No Domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">5 Users</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">10 Email Accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">10 GB Bandwidth</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">24/7 Customer Support</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">$<span data-mce-style=\"font-size: 48pt;\" style=\"font-size: 48pt;\">659</span>.99</span></p><p><span style=\"font-family: tahoma,arial,helvetica,sans-serif;\" data-mce-style=\"font-family: tahoma,arial,helvetica,sans-serif;\"><span data-mce-style=\"font-size: 14pt;\" style=\"font-size: 14pt;\">Monthly Plan</span><br></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">SIGN UP NOW</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-color=\"#27ae60\" data-el=\"table_col\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span style=\"font-size: 24pt;\" data-mce-style=\"font-size: 24pt;\">PREMIUM</span></p>\r\n						<p><span style=\"font-size: 14pt;\" data-mce-style=\"font-size: 14pt;\">All Features are Available</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">1 GB Disk Space</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">2 Databases</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-times-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-times-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">No Domains</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">5 Users</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">10 Email Accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">10 GB Bandwidth</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(255, 255, 255)\" data-icon=\"fa-check-circle\">\r\n							<i style=\"color: rgb(255, 255, 255)\" class=\"fa fa-2x fa-check-circle ptsInputShell\"></i>\r\n						</div>\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">24/7 Customer Support</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 36pt;\" style=\"font-size: 36pt;\">$<span data-mce-style=\"font-size: 48pt;\" style=\"font-size: 48pt;\">859</span>.99</span></p><p><span style=\"font-family: tahoma,arial,helvetica,sans-serif;\" data-mce-style=\"font-family: tahoma,arial,helvetica,sans-serif;\"><span data-mce-style=\"font-size: 14pt;\" style=\"font-size: 14pt;\">Monthly Plan</span><br></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">SIGN UP NOW</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n	<div style=\"clear: both;\"></div>\r\n</div>','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n	width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n  text-transform: uppercase;\r\n}\r\n#{{table.view_id}} * {\r\n   line-height: 1.2em;\r\n}\r\n#{{table.view_id}} p,\r\n#{{table.view_id}} span \r\n{\r\n   {% if table.params.font_family.val %}\r\n   	font-family: {{ table.params.font_family.val }};\r\n   {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  	{% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n  		width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n  	{% else%}\r\n  		width: {{ 100 / table.params.cols_num.val }}%;\r\n  	{% endif %}\r\n  {% else%}\r\n	width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n  padding: 0 5px;\r\n  \r\n}\r\n#{{table.view_id}} span, #{{table.view_id}} p {\r\n	word-break: break-word;\r\n}\r\n/*Bg Colors*/\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent {\r\n	background-color: {{table.params.bg_color.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent .ptsColDesc,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent .ptsActBtn,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent .ptsRows .ptsCell:hover {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 20) }};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent .ptsActBtn:hover {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -20) }};\r\n}\r\n/*Desc Col*/\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n  	display: none;\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsRows .ptsCell .ptsIcon {\r\n	margin-right: 10px;\r\n}\r\n#{{table.view_id}} .ptsColHeader,\r\n#{{table.view_id}} .ptsColDesc,\r\n#{{table.view_id}} .ptsCell {\r\n	padding: 10px;\r\n}\r\n#{{table.view_id}} .ptsColHeader {\r\n	padding-bottom: 40px;\r\n}\r\n#{{table.view_id}} .ptsColFooter {\r\n	padding: 20px 0 40px;\r\n  	text-align: center;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn {\r\n  	cursor: pointer;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn .ptsEditArea {\r\n	font-size: 22px;\r\n  	padding: 10px 15px;\r\n  	text-decoration: none !important;\r\n  	border: none !important;\r\n}\r\n#{{table.view_id}} p {\r\n	margin: 0;\r\n}\r\n/*Animations*/\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent .ptsCell,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n	transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease, background 0.3s ease;\r\n  	-webkit-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease, background 0.3s ease;\r\n    -moz-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease, background 0.3s ease;\r\n    -ms-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease, background 0.3s ease;\r\n    -o-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease, background 0.3s ease;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n	z-index: 101;\r\n  	box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	-moz-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	margin-top: -20px;\r\n}\r\n
/*Colors set*/\r\n#{{table.view_id}} .ptsCol .ptsColHeader,\r\n#{{table.view_id}} .ptsCol .ptsColHeader *\r\n{\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc,\r\n#{{table.view_id}} .ptsCol .ptsColDesc *\r\n{\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows,\r\n#{{table.view_id}} .ptsCol .ptsRows *\r\n{\r\n  	color: {{table.params.text_color.val}};\r\n}\r\n/*start for col color 1*/\r\n#{{table.view_id}} .ptsCol-1 .ptsTableElementContent {\r\n	background-color: rgb(231, 76, 60);\r\n}\r\n#{{table.view_id}} .ptsCol-1 .ptsTableElementContent .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-1 .ptsTableElementContent .ptsActBtn,\r\n#{{table.view_id}} .ptsCol-1 .ptsTableElementContent .ptsRows .ptsCell:hover {\r\n	background-color: #fb6050;\r\n}\r\n#{{table.view_id}} .ptsCol-1 .ptsTableElementContent .ptsActBtn:hover {\r\n	background-color: #d33828;\r\n}\r\n/*end for col color 1*/\r\n/*start for col color 2*/\r\n#{{table.view_id}} .ptsCol-2 .ptsTableElementContent {\r\n	background-color: rgb(155, 89, 182);\r\n}\r\n#{{table.view_id}} .ptsCol-2 .ptsTableElementContent .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-2 .ptsTableElementContent .ptsActBtn,\r\n#{{table.view_id}} .ptsCol-2 .ptsTableElementContent .ptsRows .ptsCell:hover {\r\n	background-color: #af6dca;\r\n}\r\n#{{table.view_id}} .ptsCol-2 .ptsTableElementContent .ptsActBtn:hover {\r\n	background-color: #8745a2;\r\n}\r\n/*end for col color 2*/\r\n/*start for col color 3*/\r\n#{{table.view_id}} .ptsCol-3 .ptsTableElementContent {\r\n	background-color: rgb(39, 174, 96);\r\n}\r\n#{{table.view_id}} .ptsCol-3 .ptsTableElementContent .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-3 .ptsTableElementContent .ptsActBtn,\r\n#{{table.view_id}} .ptsCol-3 .ptsTableElementContent .ptsRows .ptsCell:hover {\r\n	background-color: #3bc274;\r\n}\r\n#{{table.view_id}} .ptsCol-3 .ptsTableElementContent .ptsActBtn:hover {\r\n	background-color: #139a4c;\r\n}\r\n/*end for col color 3*/','img' => 'flat-table.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-08-28 15:55:18','is_pro' => '0'),
'Pwn8M1EB' => array('unique_id' => 'Pwn8M1EB','label' => 'Gradient Standard','original_id' => '0','params' => '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','html' => '<div class=\"ptsContainer\">\r\n	<div class=\"ptsColsWrapper\">\r\n		{% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n		<div class=\"ptsEl ptsCol ptsCol-0 ptsTableDescCol ptsElWithArea\" data-el=\"table_col_desc\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\" style=\"height: 69px;\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\" style=\"height: 141px;\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">choose <span style=\"color: rgb(59, 214, 255);\" data-mce-style=\"color: #853a3a;\">your</span> plan</span></p></div>\r\n				</div>\r\n				<div class=\"ptsRows\" style=\"height: 224px;\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Amount of space</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Bandwidth per month</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">E-mail accounts</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">MySql databases</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">24h support</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\" style=\"height: 51px;\"></div>\r\n			</div>\r\n		</div>\r\n		{% endif %}\r\n		<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">starter</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">10</span></span></p><p><span data-mce-style=\"font-size: 12pt; \" style=\"font-size: 12pt; \">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">10GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">100GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">1</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">1</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(214, 71, 71)\" data-icon=\"fa-times\">\r\n							<i style=\"color: rgb(214, 71, 71)\" class=\"fa fa-times fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-2 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">econom</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">30</span></span></p><p><span data-mce-style=\"font-size: 12pt; \" style=\"font-size: 12pt; \">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">30GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">300GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">3</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">3</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(86, 166, 0)\" data-icon=\"fa-check\">\r\n							<i style=\"color: rgb(86, 166, 0)\" class=\"fa fa-check fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">standard</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">59</span></span></p><p><span data-mce-style=\"font-size: 12pt; \" style=\"font-size: 12pt; \">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">100GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">500GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">5</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">5</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(86, 166, 0)\" data-icon=\"fa-check\">\r\n							<i style=\"color: rgb(86, 166, 0)\" class=\"fa fa-check fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-4 ptsElWithArea\" data-el=\"table_col\" data-color=\"#424242\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">pro</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"\" style=\"\"><span style=\"font-size: 36pt;\">$</span><span data-mce-style=\"font-size: 48pt; color: #3bd6ff;\" style=\"font-size: 48pt; color: rgb(59, 214, 255);\">99</span></span></p><p><span data-mce-style=\"font-size: 12pt; \" style=\"font-size: 12pt; \">per month<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">Unlimited</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">1000GB</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">Unlimited</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\" font-size: 12pt;\">Unlimited</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl ptsIcon ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"rgb(86, 166, 0)\" data-icon=\"fa-check\">\r\n							<i style=\"color: rgb(86, 166, 0)\" class=\"fa fa-check fa-2x ptsInputShell\"></i>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-elements=\".ptsEditArea\" data-bgcolor=\"#444\" data-bgcolor-to=\"txt\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #444;\">sign up!</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n	<div style=\"clear: both;\"></div>\r\n</div>','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  	{% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n  		width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n  	{% else%}\r\n  		width: {{ 100 / table.params.cols_num.val }}%;\r\n  	{% endif %}\r\n  {% else%}\r\n	width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n  transition: box-shadow 0.25 ease 0;\r\n}\r\n#{{table.view_id}} .ptsColHeader,\r\n#{{table.view_id}} .ptsColDesc {\r\n	padding: 10px;\r\n}\r\n#{{table.view_id}} p {\r\n	margin: 0;\r\n}\r\n#{{table.view_id}} .ptsCell,\r\n#{{table.view_id}} .ptsColFooter {\r\n	padding: 10px 0;\r\n}\r\n#{{table.view_id}} .ptsColHeader {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -10) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n  background-image: linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ table.params.bg_color.val }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -23) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ table.params.bg_color.val }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -23) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* IE9 */\r\n  background: -moz-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ table.params.bg_color.val }}, {{ adjBs(table.params.bg_color.val, -23) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ table.params.bg_color.val }}), color-stop(1, {{ adjBs(table.params.bg_color.val, -23) }})); /* Chrome 10, Safari */\r\n  \r\n  	border-bottom: 1px solid {{ adjBs(table.params.bg_color.val, -40) }};\r\n}\r\n#{{table.view_id}} .ptsColDesc {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -10) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n  background-image: linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, -15) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -40) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, -15) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -40) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* IE9 */\r\n  background: -moz-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -15) }}, {{ adjBs(table.params.bg_color.val, -40) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ adjBs(table.params.bg_color.val, -15) }}), color-stop(1, {{ adjBs(table.params.bg_color.val, -40) }})); /* Chrome 10, Safari */\r\n  \r\n  	border-top: 1px solid {{ adjBs(table.params.bg_color.val, 5) }};\r\n}\r\n#{{table.view_id}} .ptsCell:nth-child(odd) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 165) }};\r\n}\r\n#{{table.view_id}} .ptsCell:nth-child(even) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 195) }};\r\n}\r\n#{{table.view_id}} .ptsCol:nth-child(odd) .ptsCell:nth-child(odd) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 145) }};\r\n}\r\n#{{table.view_id}} .ptsCol:nth-child(odd) .ptsCell:nth-child(even) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 165) }};\r\n}\r\n#{{table.view_id}} .ptsColFooter {\r\n 	background-color: {{ adjBs(table.params.bg_color.val, 130) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n	background-image: linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 160) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 100) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 160) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 100) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* IE9 */\r\n	background: -moz-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 160) }}, {{ adjBs(table.params.bg_color.val, 100) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ adjBs(table.params.bg_color.val, 160) }}), color-stop(1, {{ adjBs(table.params.bg_color.val, 100) }})); /* Chrome 10, Safari */\r\n  \r\n	border-top: 1px solid {{ adjBs(table.params.bg_color.val, 145) }};\r\n}\r\n#{{table.view_id}} .ptsActBtn:hover {\r\n	 background-color: {{ adjBs(table.params.bg_color.val, 110) }}; /* background color for non-css3 browsers */\r\n	/* gradient */\r\n	background-image: linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 140) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 80) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, 140) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, 80) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* IE9 */\r\n	background: -moz-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ adjBs(table.params.bg_color.val, 140) }}, {{ adjBs(table.params.bg_color.val, 80) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ adjBs(table.params.bg_color.val, 140) }}), color-stop(1, {{ adjBs(table.params.bg_color.val, 80) }})); /* Chrome 10, Safari */\r\n}\r\n#{{table.view_id}} .ptsActBtn {\r\n	display: inline-block;\r\n  	padding: 4px 20px;\r\n  	border: 1px solid {{ adjBs(table.params.bg_color.val, 85) }};\r\n  	width: 80%;\r\n  	border-radius: 3px;\r\n}\r\n\r\n#{{table.view_id}} .ptsActBtn .ptsEditArea {\r\n	color: #444;\r\n  	font-size: 10pt; \r\n  	font-weight: bold;\r\n  	text-decoration: none !important;\r\n  	border: none !important;\r\n	width: 100%;\r\n}\r\n#{{table.view_id}} .ptsCol:first-of-type .ptsColHeader {\r\n	border-top-left-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol:last-of-type .ptsColHeader {\r\n	border-top-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol:first-of-type .ptsColFooter {\r\n	border-bottom-left-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol:last-of-type .ptsColFooter {\r\n	border-bottom-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsColFooter a {\r\n	color: #444444;\r\n  	text-decoration: none !important;\r\n}\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n  	display: none;\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n	transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n  	-webkit-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -moz-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -ms-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -o-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n	z-index: 101;\r\n  	box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n	-moz-box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n	margin-top: -20px;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsColHeader {\r\n	border-top-left-radius: 5px;\r\n  	border-top-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsColFooter {\r\n	border-bottom-left-radius: 5px;\r\n  	border-bottom-right-radius: 5px;\r\n}\r\n/*Colors set*/\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n  	color: {{table.params.text_color.val}};\r\n}\r\n','img' => 'gradient-standard.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-08-15 19:02:30','is_pro' => '0'),
'630WlOre' => array('unique_id' => '630WlOre','label' => 'Okul','original_id' => '0','params' => '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','html' => '<div class=\"ptsContainer\">\r\n<div class=\"ptsColsWrapper\">\r\n{% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n<div class=\"ptsEl ptsCol ptsCol-0 ptsTableDescCol ptsElWithArea\" data-el=\"table_col_desc\" data-color=\"#fff\">\r\n    <div class=\"ptsTableElementContent ptsElArea\">\r\n        <div class=\"ptsColHeader\" style=\"height: 69px;\">\r\n            <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p></p></div>\r\n        </div>\r\n        <div class=\"ptsColDesc\" style=\"height: 141px; color: #626262;\">\r\n            <div class=\"ptsEl mce-content-body\" data-el=\"table_cell_txt\" data-type=\"txt\" id=\"ptsTxt_94548\" contenteditable=\"true\" spellcheck=\"false\">\r\n                <p><span style=\"font-size: 46px; line-height: 56.626px; text-transform: none;\">Features</span></p>\r\n                <p>COMPARE PACKAGE FEATURES</p>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsRows\" style=\"height: 224px;\">\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Storage Space</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Email Accounts</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Monthly Bandwidth</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Control Panel</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Databases</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Analytics</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Domains</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Users</span></p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsColFooter\" style=\"height: 51px; display: none;\"></div>\r\n    </div>\r\n</div>\r\n{% endif %}\r\n<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-color=\"rgb(241, 147, 0)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n    <div class=\"ptsTableElementContent ptsElArea\">\r\n        <div class=\"ptsColHeader\">\r\n            <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                <p><span style=\"font-size: 13px; \" data-mce-style=\"font-size: 13px; color: #ffffff;\">Developer</span></p>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsColDesc\">\r\n            <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                <p><span style=\"font-size: 24pt; \" data-mce-style=\"font-size: 24pt; color: #ffffff;\">$99</span></p>\r\n                <p><span data-mce-style=\"color: #ffffff;\">Payable Every Month</span></p>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsRows\">\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">500 MB</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">100</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">5000 MB</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"#d0d0d0\" data-icon=\"fa-check\">\r\n                    <i class=\"fa fa-check ptsInputShell\"></i>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">10</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"#d0d0d0\" data-icon=\"fa-check\">\r\n                    <i class=\"fa fa-check ptsInputShell\"></i>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">10</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">100</span></p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsColFooter\">\r\n            <div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n                <a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\">Sign up!</a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-color=\"rgb(224, 100, 0)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n    <div class=\"ptsTableElementContent ptsElArea\">\r\n        <div class=\"ptsColHeader\">\r\n            <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                <p><span style=\"font-size: 13px; \" data-mce-style=\"font-size: 13px; color: #ffffff;\">PREMIUM</span></p>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsColDesc\">\r\n            <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                <p><span style=\"font-size: 24pt; \" data-mce-style=\"font-size: 24pt; color: #ffffff;\">$399</span></p>\r\n                <p><span data-mce-style=\"color: #ffffff;\">Payable Every Year</span></p>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsRows\">\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">10 TB</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Unlimited</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Unlimited</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"#d0d0d0\" data-icon=\"fa-check\">\r\n                    <i class=\"fa fa-check ptsInputShell\"></i>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">100</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"#d0d0d0\" data-icon=\"fa-check\">\r\n                    <i class=\"fa fa-check ptsInputShell\"></i>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">50</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">500</span></p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsColFooter\">\r\n            <div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n                <a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\">Sign up!</a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-color=\"rgb(195, 53, 15)\" data-el=\"table_col\" data-enb-color=\"1\">\r\n    <div class=\"ptsTableElementContent ptsElArea\">\r\n        <div class=\"ptsColHeader\">\r\n            <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                <p><span style=\"font-size: 13px; \" data-mce-style=\"font-size: 13px; color: #ffffff;\">ENTERPRISE</span></p>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsColDesc\">\r\n            <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                <p><span style=\"font-size: 24pt; \" data-mce-style=\"font-size: 24pt; color: #ffffff;\">$699</span></p>\r\n                <p><span data-mce-style=\"color: #ffffff;\">One Time Payment</span></p>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsRows\">\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">50 TB</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Unlimited</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Unlimited</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"#d0d0d0\" data-icon=\"fa-check\">\r\n                    <i class=\"fa fa-check ptsInputShell\"></i>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Unlimited</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsIcon ptsEl ptsElInput\" data-el=\"table_cell_icon\" data-type=\"icon\" data-color=\"#d0d0d0\" data-icon=\"fa-check\">\r\n                    <i class=\"fa fa-check ptsInputShell\"></i>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Unlimited</span></p>\r\n                </div>\r\n            </div>\r\n            <div class=\"ptsCell\">\r\n                <div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n                    <p><span style=\"font-size: 13px;\" data-mce-style=\"font-size: 13px;\">Unlimited</span></p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class=\"ptsColFooter\">\r\n            <div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"txt\" data-bgcolor=\"#fff\" data-bgcolor-elements=\".ptsEditArea\">\r\n                <a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\">Sign up!</a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n\r\n</div>\r\n<div style=\"clear: both;\"></div>\r\n</div>\r\n\r\n\r\n\r\n','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n	width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n  text-transform: uppercase;\r\n}\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  	{% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n  		width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n  	{% else%}\r\n  		width: {{ 100 / table.params.cols_num.val }}%;\r\n  	{% endif %}\r\n  {% else%}\r\n	width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n  transition: box-shadow 0.25 ease 0;\r\n}\r\n#{{table.view_id}} p {\r\n	margin: 0;\r\n}\r\n#{{table.view_id}} .ptsCell{\r\n	padding: 12px;\r\n	text-transform: none;\r\n	\r\n    border: 1px solid {{ adjBs(table.params.bg_color.val, 17) }};\r\n    border-bottom: 1px solid {{ adjBs(table.params.bg_color.val, -34) }};\r\n    border-right: 1px solid {{ adjBs(table.params.bg_color.val, -34) }};\r\n    box-shadow: 0 1px 2px rgba(0,0,0,0.15);\r\n    text-shadow: 0 -1px rgba(0,0,0,0.6);\r\n}\r\n#{{table.view_id}} .ptsColHeader {\r\n	padding: 15px;\r\n}\r\n#{{table.view_id}} .ptsColDesc {\r\n	padding: 30px 15px;\r\n}\r\n#{{table.view_id}} .ptsCell:nth-child(odd) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, 0) }};\r\n}\r\n#{{table.view_id}} .ptsCell:nth-child(even) {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -12) }};\r\n}\r\n#{{table.view_id}} .ptsColFooter {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -23) }};\r\n	padding: 20px;\r\n	border: 1px solid {{ adjBs(table.params.bg_color.val, -51) }};\r\n    box-shadow: inset 0 1px {{ adjBs(table.params.bg_color.val, 2) }},inset 0 0 0 1px rgba(255,255,255,0.1);\r\n	\r\n	/* gradient */\r\n	background-image: linear-gradient(top, {{ adjBs(table.params.bg_color.val, -23) }}, {{ adjBs(table.params.bg_color.val, -44) }}); /* W3C */\r\n	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, -23) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -44) }}\'); /* IE5.5 - 7 */\r\n	-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'{{ adjBs(table.params.bg_color.val, -23) }}\', endColorstr=\'{{ adjBs(table.params.bg_color.val, -44) }}\'); /* IE8 */\r\n	background: -ms-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -23) }}, {{ adjBs(table.params.bg_color.val, -44) }}); /* IE9 */\r\n	background: -moz-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -23) }}, {{ adjBs(table.params.bg_color.val, -44) }}); /* Firefox */ \r\n	background: -o-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -23) }}, {{ adjBs(table.params.bg_color.val, -44) }}); /* Opera 11  */\r\n	background: -webkit-linear-gradient(top, {{ adjBs(table.params.bg_color.val, -23) }}, {{ adjBs(table.params.bg_color.val, -44) }}); /* Chrome 11  */\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0, {{ adjBs(table.params.bg_color.val, -23) }}), color-stop(1, {{ adjBs(table.params.bg_color.val, -44) }})); /* Chrome 10, Safari */\r\n}\r\n#{{table.view_id}} .ptsActBtn:hover {\r\n	 background-color: {{ adjBs(table.params.bg_color.val, 110) }}; /* background color for non-css3 browsers */\r\n}\r\n#{{table.view_id}} .ptsActBtn {\r\n	height: 50px;\r\n	padding: 0 2em;\r\n	cursor: pointer;\r\n	font-weight: 400;\r\n    font-size: 1.4em;\r\n    text-decoration: none;\r\n	display: inline-block;\r\n  	padding: 4px 20px;\r\n  	width: 100%;\r\n  	border-radius: 3px;\r\n}\r\n\r\n#{{table.view_id}} .ptsActBtn .ptsEditArea {\r\n  	text-decoration: none !important;\r\n  	border: none !important;\r\n	width: 100%;\r\n	text-transform: none;\r\n	line-height: 2em;\r\n	color: #fff;\r\n}\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n  	display: none;\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n	transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n  	-webkit-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -moz-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -ms-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n    -o-transition: box-shadow 0.3s ease, margin 0.3s ease, font 0.3s ease;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n	z-index: 101;\r\n  	box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n	-moz-box-shadow: 5px 0 30px rgba(0, 0, 0, 0.5);\r\n	margin-top: -20px;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsColHeader {\r\n	border-top-left-radius: 5px;\r\n  	border-top-right-radius: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsColFooter {\r\n	border-bottom-left-radius: 5px;\r\n  	border-bottom-right-radius: 5px;\r\n}\r\n\r\n/*start for desc col color */\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol  .ptsColHeader {\r\n	background-color: #fff;\r\n}\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColDesc{\r\n	background-color: #fff;\r\n}\r\n/*end for desc col color */\r\n\r\n/*start for col color 1*/\r\n#{{table.view_id}} .ptsCol-1 .ptsColHeader {\r\n	background-color: #ed8000;\r\n}\r\n#{{table.view_id}} .ptsCol-1 .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-1 .ptsActBtn:hover {\r\n	background-color: #f19300;\r\n}\r\n#{{table.view_id}} .ptsCol-1 .ptsActBtn {\r\n	background-color: #ed8000;\r\n}\r\n/*end for col color 1*/\r\n\r\n/*start for col color 2*/\r\n#{{table.view_id}} .ptsCol-2 .ptsColHeader {\r\n	background-color: #D85200;\r\n}\r\n#{{table.view_id}} .ptsCol-2 .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-2 .ptsActBtn:hover {\r\n	background-color: #E06400;\r\n}\r\n#{{table.view_id}} .ptsCol-2 .ptsActBtn {\r\n	background-color: #D85200;\r\n}\r\n/*end for col color 2*/\r\n\r\n/*start for col color 3*/\r\n#{{table.view_id}} .ptsCol-3 .ptsColHeader {\r\n	background-color: #B5280B;\r\n}\r\n#{{table.view_id}} .ptsCol-3 .ptsColDesc,\r\n#{{table.view_id}} .ptsCol-3 .ptsActBtn:hover {\r\n	background-color: #C3350F;\r\n}\r\n#{{table.view_id}} .ptsCol-3 .ptsActBtn {\r\n	background-color: #B5280B;\r\n}\r\n/*end for col color 3*/\r\n\r\n/*Colors set*/\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n  	color: {{table.params.text_color.val}};\r\n}\r\n','img' => 'okul.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-11-02 17:05:29','is_pro' => '0'),
'nflGZoHy' => array('unique_id' => 'nflGZoHy','label' => 'Botein','original_id' => '0','params' => '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','html' => '<div class=\"ptsContainer\">\r\n	<div class=\"ptsColsWrapper\">\r\n      {% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n		<div class=\"ptsEl ptsCol ptsCol-0 ptsElWithArea ptsTableDescCol\" data-el=\"table_col\" data-color=\"#fff\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">PLAN</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\"data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 23pt; color: #333;\" style=\"font-size: 23pt; color: #333;\">Number</span></p><p><span data-mce-style=\"font-size: 12pt; color: #333;\" style=\"font-size: 12pt; color: #333;\">minutes<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">Price</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Price for 1 minute</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\"  data-bgcolor=\"#52C93B\" data-bgcolor-to=\"bg\" style=\"background-color: #52C93B\">\r\n						<a target=\"_blank\" class=\"ptsEditArea ptsInputShell\" href=\"https://supsystic.com/\">Action</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n      	{% endif %}\r\n		<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-el=\"table_col\" data-color=\"#fff\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">BASE</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\"data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 48pt; color: #333;\" style=\"font-size: 48pt; color: #333;\">65</span></p><p><span data-mce-style=\"font-size: 12pt; color: #333;\" style=\"font-size: 12pt; color: #333;\">minutes<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">15 $/month</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Price for 1 minute 0.25$</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\"  data-bgcolor=\"#52C93B\" data-bgcolor-to=\"bg\" style=\"background-color: #52C93B\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsAddBgEl ptsEditArea ptsInputShell\">Start work</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-2 ptsElWithArea\" data-el=\"table_col\" data-color=\"#00AED6\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">ECONOMY</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 48pt;\" style=\"font-size: 48pt;\">140</span></p><p><span data-mce-style=\"font-size: 12pt;\" style=\"font-size: 12pt;\">minutes<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">30 $/month</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Price for 1 minute 0.20$</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#52C93B\" data-bgcolor-to=\"bg\" style=\"background-color: #52C93B\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\">Start work</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-el=\"table_col\" data-color=\"#008CB1\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">STANDART</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\">\r\n						<p><span data-mce-style=\"font-size: 48pt;\" style=\"font-size: 48pt;\">240</span></p><p><span data-mce-style=\"font-size: 12pt;\" style=\"font-size: 12pt;\">minutes<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">45 $/month</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Price for 1 minute 0.2$</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\"  data-bgcolor=\"#52C93B\" data-bgcolor-to=\"bg\" style=\"background-color: #52C93B\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\">Start work</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-4 ptsElWithArea\" data-el=\"table_col\" data-color=\"#006380\" data-enb-color=\"1\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 24pt;\">PREMIUM</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\">\r\n						<p><span data-mce-style=\"font-size: 48pt;\" style=\"font-size: 48pt;\">380</span></p><p><span data-mce-style=\"font\" style=\"font-size: 12pt;\">minutes<br data-mce-bogus=\"1\"></span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 18pt;\" data-mce-style=\"font-size: 18pt;\">75 $/month</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\" font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Price for 1 minute 0.2$</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\"  data-bgcolor=\"#52C93B\" data-bgcolor-to=\"bg\" style=\"background-color: #52C93B\">\r\n						<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\">Start work</a>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n\r\n	</div>\r\n	<div style=\"clear: both;\"></div>\r\n</div>','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n	width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} span, #{{table.view_id}} p {\r\n	word-break: break-word;\r\n}\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  	{% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n  		width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n  	{% else%}\r\n  		width: {{ 100 / table.params.cols_num.val }}%;\r\n  	{% endif %}\r\n  {% else%}\r\n	width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n  border: 1px solid {{ adjBs(table.params.bg_color.val, -40) }};\r\n}\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColFooter {\r\n	visibility: hidden;\r\n}\r\n#{{table.view_id}} .ptsTableElementContent {\r\n	padding-bottom: 15px;\r\n}\r\n{% if (table.params.cols_num.val > 1) %}\r\n#{{table.view_id}} .ptsCol:not(:last-child) {\r\n	border-right: none;\r\n}\r\n{% endif %}\r\n#{{table.view_id}} .ptsColDesc {\r\n	text-align: center;\r\n}\r\n#{{table.view_id}}.ptsBlockMobile .ptsCol {\r\n	border-right: 1px solid {{ adjBs(table.params.bg_color.val, -40) }};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent .ptsRows {\r\n 	background-color: {{ table.params.bg_color.val }};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsCell {\r\n	padding: 12px;\r\n  	border-bottom: 1px solid {{ adjBs(table.params.bg_color.val, -35) }};\r\n  	border-top: 1px solid {{ adjBs(table.params.bg_color.val, -20) }};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsCell:last-of-type {\r\n	border-bottom: none;\r\n}\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn {\r\n	width: 100%;\r\n  	border-radius: 3px;\r\n  	cursor: pointer;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn .ptsEditArea {\r\n	font-size: 1.4em;\r\n  	width: 100%;\r\n  	padding: 10px 0;\r\n  	text-decoration: none !important;\r\n  	border: none !important;\r\n}\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n  	display: none;\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsRows {\r\n  	border-top-width: 1px;\r\n  	border-bottom-width: 1px;\r\n}\r\n#{{table.view_id}} p {\r\n	margin: 0;\r\n}\r\n/*Animations*/\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n	transition: all 0.3s ease;\r\n  	-webkit-transition: all 0.3s ease;\r\n    -moz-transition: all 0.3s ease;\r\n    -ms-transition: all 0.3s ease;\r\n    -o-transition: all 0.3s ease;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n	z-index: 101;\r\n  	box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	-moz-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	margin-top: -20px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn:hover {\r\n	background-color: {{ adjBs(table.params.bg_color.val, -35) }};\r\n}\r\n/*Colors set*/\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n  	color: {{table.params.text_color.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc .ptsEl {\r\n  	border-radius: 50%;\r\n    border: 10px solid {{ table.params.bg_color.val }};\r\n    padding: 15px 15px;\r\n    box-sizing: content-box;\r\n  	z-index: 1;\r\n  	background-color: {{ table.params.bg_color.val }};\r\n  	width: {{table.params.col_width.val / 1.55}}px;\r\n    height: {{table.params.col_width.val / 1.55}}px;\r\n  	position: relative;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsColDesc .ptsEl {\r\n	width: {{table.params.col_width.val / 1.40}}px;\r\n    height: {{table.params.col_width.val / 1.40}}px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n	padding: 35px 0 10px 0;\r\n  	background-color: {{ adjBs(table.params.bg_color.val, -10) }};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n	position: relative;\r\n  	padding: 5px 0 10px 0;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc:after {\r\n	content: \'\';\r\n    background-color: {{ adjBs(table.params.bg_color.val, -10) }};\r\n    position: absolute;\r\n    top: 0;\r\n    left: 0;\r\n    width: 100%;\r\n    height: 50%;\r\n    z-index: 0;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc .ptsEl p {\r\n    line-height: 1;\r\n    padding: 10px 0 0 0;\r\n    margin: 0 0;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc .ptsEl p:first-child {\r\n	margin-top: 5px;\r\n}\r\n#{{table.view_id}} .ptsCol-0 .ptsColDesc .ptsEl p:first-child {\r\n	margin-top: 30px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColFooter {\r\n	padding: 15px 0 0 0;\r\n  	margin-top: 40px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColFooter .ptsActBtn {\r\n	width: auto;\r\n    padding: 7px 12px;\r\n  	border-radius: 2px;\r\n  	cursor: pointer;\r\n    transition: box-shadow .5s ease-out;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColFooter .ptsActBtn:hover {\r\n  	box-shadow: 2px 2px 1px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 2px 2px 1px rgba(0, 0, 0, 0.5);\r\n  	-moz-box-shadow: 2px 2px 1px rgba(0, 0, 0, 0.5);\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColFooter .ptsActBtn a {\r\n	padding: 0;\r\n  	color: {{ table.params.bg_color.val }};\r\n  	font-size: 17px;\r\n  	text-decoration: blink;\r\n  	\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows .ptsCell {\r\n    padding: 1px 0;\r\n  	border: none;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc .ptsEl p:last-child {\r\n	position: absolute;\r\n    left: 0;\r\n    right: 0;\r\n    bottom: 0;\r\n    height: 40%;\r\n}\r\n/** Default colum style **/\r\n/*start for col color 2*/\r\n#{{table.view_id}} .ptsCol-2 .ptsColDesc .ptsEl {\r\n	background-color: #00AED6;\r\n}\r\n/*end for col color 2*/\r\n/*start for col color 3*/\r\n#{{table.view_id}} .ptsCol-3 .ptsColDesc .ptsEl {\r\n	background-color: #008CB1;\r\n}\r\n/*end for col color 3*/\r\n/*start for col color 4*/\r\n#{{table.view_id}} .ptsCol-4 .ptsColDesc .ptsEl {\r\n	background-color: #006380;\r\n}\r\n/*end for col color 4*/','img' => 'botein.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-11-03 08:45:18','is_pro' => '0'),
'vpQwsfZU' => array('unique_id' => 'vpQwsfZU','label' => 'Becrux','original_id' => '0','params' => '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','html' => '<div class=\"ptsContainer\">\r\n	<div class=\"ptsColsWrapper\">\r\n		{% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n		<div class=\"ptsEl ptsCol ptsCol-0 ptsElWithArea ptsTableDescCol\" data-el=\"table_col_desc\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 18pt; font-weight: bold;\" data-mce-style=\"font-size: 18pt; font-weight: bold;\">Plan</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 18pt;\" style=\"font-size: 18pt;\">(Price)</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Email Previews</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Builder</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Page Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Interactive Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Spam Filter Tests</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500,000 Tracking Opens</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"\">2 Users Free</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		{% endif %}\r\n		<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-el=\"table_col\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 18pt; font-weight: bold;\" data-mce-style=\"font-size: 18pt; font-weight: bold;\">Basic</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 18pt;\" style=\"font-size: 18pt;\">($79/mo)</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"bg\" data-bgcolor=\"#27AE60\" style=\"background-color: #27AE60;\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">Start Free Trial</a>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Email Previews</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Builder</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Page Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Interactive Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Spam Filter Tests</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500,000 Tracking Opens</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"\">2 Users Free</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-2 ptsElWithArea\" data-el=\"table_col\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 18pt; font-weight: bold; color: #515E78;\" data-mce-style=\"font-size: 18pt; font-weight: bold; color: #515E78;\">Plus</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 18pt;\" style=\"font-size: 18pt;\">($149/mo)</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"bg\" data-bgcolor=\"#515E78\" style=\"background-color: #515E78;\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">Start Free Trial</a>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Email Previews</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Builder</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Page Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Interactive Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Spam Filter Tests</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">500,000 Tracking Opens</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"\">2 Users Free</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-el=\"table_col\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\"><p><span style=\"font-size: 18pt; font-weight: bold; color: #FB9B7A;\" data-mce-style=\"font-size: 18pt; font-weight: bold; color: #FB9B7A;\">Premium</span></p></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p><span data-mce-style=\"font-size: 18pt; color: #505055;\" style=\"font-size: 18pt;\">($399/mo)</span></p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor-to=\"bg\" data-bgcolor=\"#FB9B72\" style=\"background-color: #FB9B72;\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"color: #fff;\">Start Free Trial</a>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Email Previews</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Builder</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Page Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Interactive Testing</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">Spam Filter Tests</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"font-size: 12pt;\">2 Million Tracking Opens</span></p>\r\n						</div>\r\n					</div>\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p><span style=\"font-size: 12pt;\" data-mce-style=\"\">10 Users Free</span></p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n	<div style=\"clear: both;\"></div>\r\n</div>','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n		width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n}\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  	{% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n  		width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n  	{% else%}\r\n  		width: {{ 100 / table.params.cols_num.val }}%;\r\n  	{% endif %}\r\n  {% else%}\r\n	width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n  \r\n  padding: 0px 2.5px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent {\r\n  box-sizing: border-box;\r\n  	border: solid 1px {{ adjBs(table.params.bg_color.val, -10) }};\r\n    border-bottom: solid 2px {{ adjBs(table.params.bg_color.val, -15) }};\r\n    border-top-width: 2px;\r\n  	background-color: {{ table.params.bg_color.val }};\r\n\r\n}\r\n#{{table.view_id}} .ptsColHeader {\r\n	padding: 15px;\r\n  	font-size: 24px;\r\n  	font-weight: bold;\r\n  	padding-top: 21px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n  	font-size: 24px;\r\n  	padding-top: 6px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n    padding-top: 30px;\r\n  	padding-bottom: 16px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsCell {\r\n	padding: 7px 12px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColFooter {\r\n	padding: 20px;\r\n  	border: 1px solid {{ adjBs(table.params.bg_color.val, -35) }};\r\n  	background-image: linear-gradient(to bottom, {{adjBs(table.params.bg_color.val, 20)}}, {{adjBs(table.params.bg_color.val, -20)}});\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn {\r\n  	border-radius: 3px;\r\n  	cursor: pointer;\r\n  	margin-bottom: 17px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBt:hover {\r\n	background-color: {{adjBs(table.params.bg_color.val, 20)}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn .ptsEditArea {\r\n  	width: 100%;\r\n  	padding: 6px 16px;\r\n  	text-decoration: none !important;\r\n  	border: none !important;\r\n}\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n  	display: none;\r\n  {% endif %}\r\n}\r\n\r\n\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColFooter {\r\n	visibility: hidden;\r\n}\r\n#{{table.view_id}} p {\r\n	margin: 0;\r\n}\r\n/*Animations*/\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n	transition: all 0.3s ease;\r\n  	-webkit-transition: all 0.3s ease;\r\n    -moz-transition: all 0.3s ease;\r\n    -ms-transition: all 0.3s ease;\r\n    -o-transition: all 0.3s ease;\r\n}\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n	z-index: 101;\r\n  	box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n  	-webkit-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	-moz-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n	margin-top: -20px;\r\n}\r\n#{{table.view_id}} .ptsCol .ptsActBtn a {\r\n	font-size: 14px;\r\n}\r\n/*Colors set*/\r\n#{{table.view_id}} .ptsCol .ptsColHeader {\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsColDesc {\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n#{{table.view_id}} .ptsCol .ptsRows {\r\n  	color: {{table.params.text_color.val}};\r\n}','img' => 'becrux.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-11-03 15:09:42','is_pro' => '0'),
'8Pw6vDxO' => array('unique_id' => '8Pw6vDxO','label' => 'Packages 1','original_id' => '0','params' => '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','html' => '<div class=\"ptsContainer\">\r\n	<div class=\"ptsColsWrapper\">\r\n		<!-- Start Test Element -->\r\n       {% if (table.params.enb_desc_col.val == 1 or isEditMode) %}\r\n      	<div class=\"ptsEl ptsCol ptsCol-0 ptsElWithArea ptsTableDescCol\" data-el=\"table_col_desc\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div data-icon=\"fa-pencil\" data-type=\"icon\" data-el=\"table_cell_icon\" class=\"ptsIcon ptsEl ptsElInput\"><i class=\"fa fa-2x ptsInputShell fa-pencil\"></i></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p>\r\n							<span data-mce-style=\"\">\r\n								PLAN - PRICE\r\n							</span>\r\n						</p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p>\r\n								<span data-mce-style=\"\">Description</span>\r\n							</p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 12px; background-color: #333;\">READ MORE</a>\r\n						</div>\r\n					</div>\r\n\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 14px; background-color: #333;\">BUY NOW</a>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n      	 {% endif %}\r\n      	<div class=\"ptsEl ptsCol ptsCol-1 ptsElWithArea\" data-el=\"table_col\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div data-icon=\"fa-pencil\" data-type=\"icon\" data-el=\"table_cell_icon\" class=\"ptsIcon ptsEl ptsElInput\"><i class=\"fa fa-2x ptsInputShell fa-pencil\"></i></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p>\r\n							<span data-mce-style=\"\">\r\n								START UP - $ 29\r\n							</span>\r\n						</p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p>\r\n								<span data-mce-style=\"\">Semper audire mnesarchum</br> No alia prompta torquatos</br> Melius omnesque at sed</span>\r\n							</p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 12px; background-color: #333;\">READ MORE</a>\r\n						</div>\r\n					</div>\r\n\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 14px; background-color: #333;\">BUY NOW</a>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-2 ptsElWithArea\" data-el=\"table_col\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div data-icon=\"fa-cog\" data-type=\"icon\" data-el=\"table_cell_icon\" class=\"ptsIcon ptsEl ptsElInput\"><i class=\"fa fa-2x ptsInputShell fa-cog\"></i></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p>\r\n							<span data-mce-style=\"\">\r\n								BUSINESS - $ 49\r\n							</span>\r\n						</p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p>\r\n								<span data-mce-style=\"\">Utinam sapientem vim iusto<br/>Delenit medioc ritaten duo</br>Sed probo assun nonavi</span>\r\n							</p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 12px; background-color: #333;\">READ MORE</a>\r\n						</div>\r\n					</div>\r\n\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 14px; background-color: #333;\">BUY NOW</a>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"ptsEl ptsCol ptsCol-3 ptsElWithArea\" data-el=\"table_col\">\r\n			<div class=\"ptsTableElementContent ptsElArea\">\r\n				<div class=\"ptsColHeader\">\r\n					<div data-icon=\"fa-inbox\" data-type=\"icon\" data-el=\"table_cell_icon\" class=\"ptsIcon ptsEl ptsElInput\"><i class=\"fa fa-2x ptsInputShell fa-inbox\"></i></div>\r\n				</div>\r\n				<div class=\"ptsColDesc\">\r\n					<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n						<p>\r\n							<span data-mce-style=\"\">\r\n								ADVANCED - $ 99\r\n							</span>\r\n						</p>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsRows\">\r\n					<div class=\"ptsCell\">\r\n						<div class=\"ptsEl\" data-el=\"table_cell_txt\" data-type=\"txt\">\r\n							<p>\r\n								<span data-mce-style=\"\">Semper audire mnesarchum</br>No alia prompta torquatos</br>Melius omnesque at sed</span>\r\n							</p>\r\n						</div>\r\n					</div>\r\n				</div>\r\n				<div class=\"ptsColFooter\">\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 12px; background-color: #333;\">READ MORE</a>\r\n						</div>\r\n					</div>\r\n\r\n					<div class=\"ptsActBtnWp\">\r\n						<div class=\"ptsActBtn ptsEl ptsElInput\" data-el=\"btn\" data-bgcolor=\"#333\" data-bgcolor-elements=\"a\" data-bgcolor-to=\"bg\">\r\n							<a target=\"_blank\" href=\"https://supsystic.com/\" class=\"ptsEditArea ptsInputShell\" style=\"font-size: 14px; background-color: #333;\">BUY NOW</a>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n      \r\n		\r\n		<!-- End Test Element -->\r\n	</div>\r\n	<div style=\"clear: both;\"></div>\r\n</div>','css' => '#{{table.view_id}} {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n  width: {{ table.params.table_width.val }}{{ table.params.table_width_measure.val }};\r\n  {% endif %}\r\n}\r\n\r\n#{{table.view_id}} .ptsCol {\r\n  {% if table.params.calc_width.val == \'table\' %}\r\n    {% if table.params.enb_desc_col.val and table.params.enb_desc_col.val != \"0\" %}\r\n      width: {{ 100 / (table.params.cols_num.val + 1) }}%;\r\n    {% else%}\r\n      width: {{ 100 / table.params.cols_num.val }}%;\r\n    {% endif %}\r\n  {% else%}\r\n  width: {{ table.params.col_width.val }}px;\r\n  {% endif %}\r\n}\r\n\r\n#{{table.view_id}} .ptsTableDescCol {\r\n  {% if table.params.enb_desc_col.val == 0 %}\r\n    display: none;\r\n  {% endif %}\r\n}\r\n\r\n#{{table.view_id}} .ptsCol.ptsTableDescCol .ptsColFooter {\r\n	visibility: hidden;\r\n}\r\n\r\n#{{table.view_id}} p {\r\n  margin: 0;\r\n}\r\n\r\n/*Animations*/\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent,\r\n#{{table.view_id}} .ptsCol .ptsTableElementContent span {\r\n  transition: all 0.3s ease;\r\n    -webkit-transition: all 0.3s ease;\r\n    -moz-transition: all 0.3s ease;\r\n    -ms-transition: all 0.3s ease;\r\n    -o-transition: all 0.3s ease;\r\n}\r\n\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n  z-index: 101;\r\n  box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n  -webkit-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n  -moz-box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n}\r\n\r\n#{{table.view_id}} .ptsCol.hover .ptsTableElementContent {\r\n  z-index: 101;\r\n  box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);\r\n}\r\n\r\n/** Template Style **/\r\n#{{table.view_id}} .ptsTableElementContent {\r\n    background: {{table.params.bg_color.val}};\r\n    border: solid 1px {{adjBs(table.params.bg_color.val, -15)}};\r\n    box-shadow: 0 0 20px -2px rgba(0,0,0,0);\r\n    position: relative;\r\n}\r\n\r\n#{{table.view_id}} .ptsColHeader,\r\n#{{table.view_id}} .ptsColDesc {\r\n    background: {{adjBs(table.params.bg_color.val, -5)}};\r\n    padding: 40px 5px 30px 5px;\r\n  	position: relative;\r\n}\r\n\r\n#{{table.view_id}} .ptsColDesc:before {\r\n	content: \'\';\r\n  	position: absolute;\r\n  	left: 25%;\r\n  	bottom: 0;\r\n  background-color: {{table.params.text_color_desc.val}};\r\n  	height: 1px;\r\n  	width: 50%;\r\n}\r\n\r\n#{{table.view_id}} .ptsColHeader .ptsIcon i {\r\n	font-size: 55px;\r\n  	color: {{table.params.text_color_header.val}};\r\n}\r\n\r\n#{{table.view_id}} .ptsColHeader span,\r\n#{{table.view_id}} .ptsColHeader p {\r\n    font-size: 28px;\r\n    color: {{table.params.text_color_header.val}};\r\n}\r\n\r\n#{{table.view_id}} .ptsColDesc {\r\n    padding: 0 5px 20px 5px;\r\n}\r\n\r\n#{{table.view_id}} .ptsRows {\r\n	padding-top: 20px;\r\n}\r\n\r\n#{{table.view_id}} .ptsColDesc span,\r\n#{{table.view_id}} .ptsColDesc p {\r\n    font-size: 24px;\r\n  	color: {{table.params.text_color_desc.val}};\r\n}\r\n\r\n#{{table.view_id}} .ptsCell {\r\n  color: {{table.params.text_color.val}};\r\n}\r\n\r\n#{{table.view_id}} .ptsCell span,\r\n#{{table.view_id}} .ptsCell p {\r\n  font-size: 14px;\r\n}\r\n\r\n#{{table.view_id}} .ptsColFooter {\r\n  padding: 20px 0 20px 0;\r\n}\r\n\r\n#{{table.view_id}} .ptsColFooter .ptsActBtn a {\r\n    background-color: {{adjBs(table.params.bg_color.val, -5)}};\r\n    text-decoration: blink;\r\n 	color: {{table.params.bg_color.val}};\r\n    font-size: 18px;\r\n    padding: 10px 20px;\r\n    border-radius: 4px;\r\n    position: relative;\r\n  	text-align: center;\r\n}\r\n\r\n#{{table.view_id}} .ptsColFooter .ptsActBtn {\r\n	margin: 10px 0;\r\n  	text-align: center;\r\n}\r\n\r\n#{{table.view_id}} .ptsColFooter .ptsActBtn a:before {\r\n    content: \'\';\r\n    position: absolute;\r\n    top: 0;\r\n    right: 0;\r\n    left: 0;\r\n    bottom: 0;\r\n    background-color: #fff;\r\n    opacity: 0;\r\n    transition: all .5s ease-out;\r\n}\r\n\r\n#{{table.view_id}} .ptsColFooter .ptsActBtn a:hover:before {\r\n    opacity: .3;\r\n}','img' => 'packages-1.jpg','sort_order' => '0','is_base' => '1','date_created' => '2015-11-12 16:24:57','is_pro' => '0'),
);
		foreach($data as $uid => $d) {
			self::installDataByUid('@__tables', $uid, $d);
		}
	}
	static public function installDataByUid($tbl, $uid, $data) {
		$id = (int) dbPts::get("SELECT id FROM $tbl WHERE unique_id = '$uid' AND original_id = 0 AND is_base = 1", 'one');
		$action = $id ? 'UPDATE' : 'INSERT INTO';
		$values = array();
		foreach($data as $k => $v) {
			$values[] = "$k = \"$v\"";
		}
		$valuesStr = implode(',', $values);
		$query = "$action $tbl SET $valuesStr";
		if($action == 'UPDATE')
			$query .= " WHERE unique_id = '$uid' AND original_id = 0 AND is_base = 1";
		if(dbPts::query($query)) {
			$dataId = $action == 'UPDATE' ? $id : dbPts::insertID();
			// Make sure that data - is really unique
			$wrongId = (int) dbPts::get("SELECT id FROM $tbl WHERE unique_id != '$uid' AND original_id = 0 AND is_base = 1 AND label = '". $data['label']. "'", 'one');
			if($wrongId) {
				dbPts::query("DELETE FROM $tbl WHERE id = $wrongId");
				dbPts::query("UPDATE $tbl SET original_id = $dataId WHERE original_id = $wrongId");
			}
			return $dataId;
		}
		return false;
	}
}
