---
title: Genesis Developer Features
menuTitle: Developer Features
layout: layouts/base.njk
permalink: developer-features/index.html
tags: docs
---

Genesis enhances WordPress with powerful features that site owners love.


## For your clients

Developers using Genesis can offer their clients these features without having to build them from scratch or install additional plugins:

- **Selectable page and archive layouts**, including full-width, content-sidebar, sidebar-content and more.
- **Accessible HTML markup** and other accessibility considerations.
- **Great SEO by default**, with schema.org markup and SEO options that require no additional plugins unless you choose to use your own.
- **Custom widgets** for User Profile, Features Posts, and Featured Page.
- **Custom meta boxes** such as the Scripts field, enabling per-page JavaScript for conversion analytics and more.
- **A range of extendable theme options** such as how archives are displayed.
- **Gutenberg Optimized child themes** that you can build upon and adapt. See [Genesis child themes](https://my.studiopress.com/themes/).

<p class="notice-small">
The Tenon accessibility team found <strong>Genesis-powered WordPress sites are the most accessible</strong> in <a href="https://blog.tenon.io/tenon-research-first-glimpse-the-best-worst-of-content-management-systems/">their survey of content management systems and frameworks</a>.
</p>

<a href="https://www.studiopress.com/features/" class="button">Discover Genesis on studiopress.com</a>

## For developers

Genesis offers features for busy developers too:

- **Genesis provides a <a href="{{ '/basics/how-genesis-works/' | url }}">battle-tested HTML structure by default</a>** to help you avoid SEO and accessibility pitfalls when hand-writing HTML from scratch, and to accelerate the development cycle.
- **The <a href="{{ '/developer-features/onboarding/' | url }}">Genesis Onboarding API</a> is a theme setup wizard** for Genesis child themes that enables you to install plugins and set up sample homepage and page content upon theme activation.
- **The <a href="{{ '/developer-features/configuration/' | url }}">Genesis Configuration API</a>** lets you override Genesis configuration in your child theme, and store your own PHP configuration centrally in your theme's `config` folder.
- **Genesis offers a wealth of <a href="{{ '/developer-features/theme-support/' | url }}">theme support options</a>** to enhance your custom child theme with Genesis features. These also simplify the addition of common site functionality such as footer and after-post widget areas.
- **A starter child theme called [Genesis Sample](https://github.com/studiopress/genesis-sample/releases)** to use as a starting point for your Genesis powered sites.
- <a href="{{ '/developer-features/constants/' | url }}">**Constants**</a>, filters, actions, and helper functions to control the output of Genesis child themes with minimal and maintainable code.
- **A vibrant <a href="{{ '/contribute/community/' | url }}">Genesis community</a>** to get help and share your feedback.
- **A documented <a href="{{ '/contribute/' | url }}">contribution process</a>** via GitHub.
- **A <a href="{{ '/changelog/' | url }}">release history</a> dating back to January 2010** and a bright roadmap.

Learn <a href="{{ '/basics/' | url }}">what you need to develop with Genesis</a>, put your questions to the <a href="{{ '/contribute/community/' | url }}">Genesis community</a>, or get Genesis now:

<a href="https://www.studiopress.com/features/#genesis-feature-9" class="button">Get Genesis</a>