<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

add_action( 'customize_register', 'genesis_customize_register' );
/**
 * Include, instantiate, and initialize the Genesis Customizer object.
 *
 * @since 2.6.0
 *
 * @param WP_Customize_Manager $wp_customize WP Customizer Manager object.
 */
function genesis_customize_register( WP_Customize_Manager $wp_customize ) {

	$genesis_customizer = new Genesis_Customizer( $wp_customize );
	$genesis_customizer->init();

}

add_action( 'genesis_customizer', 'genesis_customizer_theme_settings' );
/**
 * Build the Theme Settings Customizer panels, sections, and controls.
 *
 * @since 2.6.0
 *
 * @param Genesis_Customizer $genesis_customizer Genesis Customizer object.
 */
function genesis_customizer_theme_settings( Genesis_Customizer $genesis_customizer ) {

	$config = genesis_get_config( 'customizer-theme-settings' );

	/**
	 * Filter the `$config` array, built from /config/customizer-theme-settings.php.
	 *
	 * @since 2.6.0
	 *
	 * @param array $config The config array for theme settings in the Customizer.
	 */
	$config = apply_filters( 'genesis_customizer_theme_settings_config', $config );

	$genesis_customizer->register( $config );

}

add_action( 'genesis_customizer', 'genesis_customizer_seo_settings' );
/**
 * Build the SEO Settings Customizer panels, sections, and controls.
 *
 * @since 2.6.0
 *
 * @param Genesis_Customizer $genesis_customizer Genesis Customizer object.
 */
function genesis_customizer_seo_settings( Genesis_Customizer $genesis_customizer ) {

	$config = genesis_get_config( 'customizer-seo-settings' );

	/**
	 * Filter the `$config` array, built from /config/customizer-seo-settings.php.
	 *
	 * @since 2.6.0
	 *
	 * @param array $config The config array for seo settings in the Customizer.
	 */
	$config = apply_filters( 'genesis_customizer_seo_settings_config', $config );

	$genesis_customizer->register( $config );

}

/**
 * Return array of color scheme choices for the Customizer.
 *
 * @since 2.6.0
 *
 * @return array Choices of color schemes.
 */
function genesis_get_color_schemes_for_customizer() {
	if ( ! genesis_has_color_schemes() ) {
		return array();
	}

	$color_schemes = get_theme_support( 'genesis-style-selector' );

	return array_merge(
		array( '' => __( 'Default', 'genesis' ) ),
		array_shift( $color_schemes )
	);
}

/**
 * Return true if color schemes are registered.
 *
 * @since 2.6.0
 *
 * @return bool True if color schemes are registered, false otherwise.
 */
function genesis_has_color_schemes() {
	if ( ! current_theme_supports( 'genesis-style-selector' ) ) {
		return false;
	}

	$schemes = get_theme_support( 'genesis-style-selector' );

	return is_array( $schemes ) && count( $schemes[0] ) >= 1;
}

/**
 * Return true if Header section in Customizer -> Theme Settings should be shown.
 *
 * @since 2.6.0
 *
 * @return bool True if Header section should be shown, false otherwise.
 */
function genesis_show_header_customizer_callback() {
	return ! current_theme_supports( 'genesis-custom-header' ) && ! current_theme_supports( 'custom-header' );
}

/**
 * Return true if user has chosen to show posts on the front page.
 *
 * @since 2.6.0
 *
 * @return bool True if posts is selected, false otherwise.
 */
function genesis_posts_show_on_front() {
	return 'posts' === get_option( 'show_on_front' );
}

/**
 * Return true if user has chosen to show a static page on the front page.
 *
 * @since 2.6.0
 *
 * @return bool True if static page is selected, false otherwise.
 */
function genesis_page_show_on_front() {
	return 'page' === get_option( 'show_on_front' );
}
