<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    http://my.studiopress.com/themes/genesis/
 */

?>
<table class="form-table">
<tbody>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Google AdSense Publisher ID', 'genesis' ); ?></th>
		<td>
			<p><span class="description"><?php printf( __('Auto Ads must be enabled in your AdSense account for this feature to work properly. <a href="%s">Click here to enable.</a>', 'genesis' ), 'https://www.google.com/adsense/new/myads/auto-ads/' ); ?></span></p>
			<p><span class="description"><?php printf( __( 'Don\'t have AdSense? <a href="%s" target="_blank" rel="noopener noreferrer">Click here</a> to sign up!', 'genesis' ), 'https://www.google.com/adsense/start/?utm_source=Genesis&utm_medium=partnerships&utm_campaign=GenesisThemeSettings' ); ?></span></p>
			<p><span class="description"><label for="<?php $this->field_id( 'adsense_id' ); ?>"><?php esc_html_e( 'AdSense publisher ID', 'genesis' ); ?></label></span></p>
			<p><input type="text" name="<?php $this->field_name( 'adsense_id' ); ?>" class="regular-text" id="<?php $this->field_id( 'adsense_id' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'adsense_id' ) ); ?>" placeholder="ca-pub-xxxxxxxxxxxxx" /></p>
			<p><span class="description"><?php esc_html_e( 'Enter your AdSense publisher ID (ca-pub-xxxxxxxxxxxxx or pub-xxxxxxxxxxxxx) to enable AdSense.', 'genesis' ); ?></span></p>
		</td>
	</tr>

</tbody>
</table>
