<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<div class="wrap">
	<h1 class="genesis-onboarding-page-title"><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<div class="genesis-onboarding-page-wrap">
		<main class="genesis-onboarding-main">
			<h2 class="genesis-onboarding-intro-title"><?php esc_html_e( 'Create your new homepage.', 'genesis' ); ?></h2>
			<p class="genesis-onboarding-intro-text"><?php esc_html_e( 'The new WordPress editor makes it easy to create and customize a homepage with live-view editing. This theme supports the new editor and a customizable homepage!', 'genesis' ); ?></p>
			<p class="genesis-onboarding-intro-text"><?php esc_html_e( 'Click the "Set Up Your Homepage" button below to get started. We will add the necessary plugins and demo content to create a beautiful homepage for your site.', 'genesis' ); ?></p>
			<div class="genesis-onboarding-progress-bar-wrapper">
				<span id="genesis-onboarding-progress-bar"></span>
			</div>

			<button id="genesis-onboarding-start" class="genesis-onboarding-button genesis-onboarding-button-blue" data-task="dependencies" data-step="0"><?php esc_html_e( 'Set up your homepage', 'genesis' ); ?></button>
			<a id="genesis-onboarding-settings-link" class="genesis-onboarding-button genesis-onboarding-button-alt" href="<?php echo esc_url( admin_url( 'customize.php?return=' . admin_url( 'admin.php?page=genesis-getting-started' ) ) ); ?>"><?php esc_html_e( 'Or go to Theme Settings', 'genesis' ); ?></a>

			<ul class="genesis-onboarding-list">
				<li class="genesis-onboarding-task-dependencies">
					<div class="genesis-onboarding-task-steps">
						<div class="genesis-onboarding-step-one">
							<span><?php esc_html_e( '1', 'genesis' ); ?></span>
						</div>
						<div class="genesis-onboarding-step-two">
							<svg class="genesis-onboarding-list-spinner" viewBox="0 0 50 50">
								<circle class="path" cx="25" cy="25" r="23" fill="none" stroke-width="4"></circle>
							</svg>
						</div>
						<div class="genesis-onboarding-step-three">
							<svg style="width:50px; height:50px;" viewBox="0 0 10 10">
								<circle cx="5" cy="5" r="4.5" style="stroke:#6c8196; stroke-width:0.7; fill:none;"></circle>
								<polyline points="2.7,5 4.2,6.7 7.5,3.6" style="stroke:#6c8196; stroke-width:0.7; stroke-linejoin:round; stroke-linecap:round; fill:none;"></polyline>
							</svg>
						</div>
					</div>

					<h3><?php esc_html_e( 'Recommended plugins', 'genesis' ); ?></h3>
					<p><?php printf( esc_html__( 'Plugins that ensure the homepage content is imported and set up correctly: %s', 'genesis' ), implode( ', ', wp_list_pluck( genesis_onboarding_plugins(), 'name' ) ) ); ?> </p>
				</li>

				<li class="genesis-onboarding-task-content">
					<div class="genesis-onboarding-task-steps">
						<div class="genesis-onboarding-step-one">
							<span><?php esc_html_e( '2', 'genesis' ); ?></span>
						</div>
						<div class="genesis-onboarding-step-two">
							<svg class="genesis-onboarding-list-spinner" viewBox="0 0 50 50">
								<circle class="path" cx="25" cy="25" r="23" fill="none" stroke-width="4"></circle>
							</svg>
						</div>
						<div class="genesis-onboarding-step-three">
							<svg style="width:50px; height:50px;" viewBox="0 0 10 10">
								<circle cx="5" cy="5" r="4.5" style="stroke:#6c8196; stroke-width:0.7; fill:none;"></circle>
								<polyline points="2.7,5 4.2,6.7 7.5,3.6" style="stroke:#6c8196; stroke-width:0.7; stroke-linejoin:round; stroke-linecap:round; fill:none;"></polyline>
							</svg>
						</div>
					</div>

					<h3><?php esc_html_e( 'Demo content', 'genesis' ); ?></h3>
					<p><?php esc_html_e( 'Next, we’ll add the content to make your site look like the theme demo homepage.', 'genesis' ); ?></p>
				</li>

				<li class="genesis-onboarding-task-final">
				<div class="genesis-onboarding-task-steps">
					<div class="genesis-onboarding-step-one">
							<span><?php esc_html_e( '3', 'genesis' ); ?></span>
						</div>
						<div class="genesis-onboarding-step-two">
							<svg class="genesis-onboarding-list-spinner" viewBox="0 0 50 50">
								<circle class="path" cx="25" cy="25" r="23" fill="none" stroke-width="4"></circle>
							</svg>
						</div>
						<div class="genesis-onboarding-step-three">
							<svg style="width:50px; height:50px;" viewBox="0 0 10 10">
								<circle cx="5" cy="5" r="4.5" style="stroke:#6c8196; stroke-width:0.7; fill:none;"></circle>
								<polyline points="2.7,5 4.2,6.7 7.5,3.6" style="stroke:#6c8196; stroke-width:0.7; stroke-linejoin:round; stroke-linecap:round; fill:none;"></polyline>
							</svg>
						</div>
					</div>

					<h3><?php esc_html_e( 'All done!', 'genesis' ); ?></h3>
					<p><?php esc_html_e( 'Your homepage setup is complete! View or edit your homepage using the buttons below.', 'genesis' ); ?></p>

					<a id="genesis-onboarding-view-homepage" class="genesis-onboarding-button genesis-onboarding-button-blue" href="<?php echo esc_url( home_url() ); ?>"><?php esc_html_e( 'View your homepage', 'genesis' ); ?></a>
					<a id="genesis-onboarding-edit-homepage" class="genesis-onboarding-button genesis-onboarding-button-blue" href="#"><?php esc_html_e( 'Edit your homepage', 'genesis' ); ?></a>
				</li>
			</ul>
		</main>

		<aside class="genesis-onboarding-sidebar">
			<section>
				<h3><?php esc_html_e( 'Helpful Links', 'genesis' ); ?></h3>
				<p><?php esc_html_e( 'Learn about the new WordPress editor (Gutenberg) and building with content blocks by using these resources below.', 'genesis' ); ?></p>
				<ul>
					<li><a href="https://wordpress.org/gutenberg/"><?php esc_html_e( 'Gutenberg Intro', 'genesis' ); ?></a></li>
					<li><a href="https://studiopress.blog"><?php esc_html_e( 'StudioPress Blog', 'genesis' ); ?></a></li>
					<li><a href="https://gutenberg.news"><?php esc_html_e( 'Gutenberg News', 'genesis' ); ?></a></li>
					<li><a href="https://atomicblocks.com"><?php esc_html_e( 'Atomic Blocks', 'genesis' ); ?></a></li>
				</ul>
			</section>
		</aside>
	</div><!-- .genesis-onboarding-page-wrap -->
</div>
