## 1.9.0 - 2013-01-07
### Added
- Add `.entry` class to all content, in preparation for the potential absence of `.hentry` in a HTML5-flavoured Genesis that prefers Microdata over Microformats.
- Add filter for term meta defaults.
- Add comment header wrapping div.
- Add ability to disable the loading of all breadcrumb features.
- Add `archive-title` class to archive titles.
- Add fallback parameter to `genesis_get_image()`.
- Add a What's New page.
- Add front page and posts page breadcrumb settings.
- Add search result page title.
- Add menu highlight class.
- Add link to download Genesis for Beginners to readme.
- Add support for `rel="author"` link tag, allowing author highlighting on Google result pages.

### Changed
- Improve `genesis_site_layout()` by allowing cache to be bypassed.
- Improve custom field saving function.
- Improve how Genesis / child theme style sheet is referenced, by enqueueing it.
- Improve post title output, adding a filter to decide if it should be linked to the single post on archive pages (default is true, as currently).
- Improve user meta fields integration by limiting to admin back-end only.
- Improve method to check to see if Scribe is installed.
- Improve breadcrumb class for PHP 5.
- Improve comment template by only loading it when needed.
- Improve wording on SEO Settings page, including Scribe marketing notice.
- Improve theme settings page by hiding update options when automatic updates are programatically disabled.
- Improve organization of CSS.
- Improve overall base design:
    - Increased maximum width, 1152px.
    - Different font.
    - Default styles for HTML5 elements.
    - Fluid-width columns.
    - Use of rem units with pixel fallback.
- Improve usage of proper defaults in eNews widget.
- Improve License description by changing from "GPL v2.0 (or later)" to "GPL-2.0+" as per SPDX open source license registry.
- Improve default document title separator from being a hyphen-minus character to an em-dash.
- Improve `.pot` file.

### Removed
- Remove `i18n.php` and moved textdomain load to `init.php`.
- Remove legacy customer header code.
- Remove on / off setting for primary and secondary menus in favour of theme nav menu locations to determine visibility.
- Remove settings for eNews widget (consider it deprecated).
- Remove settings for Latest Tweets widget (consider it deprecated).

### Fixed
- Fix call to `genesis_site_layout()` resetting the query.
- Fix the custom header body class conditional for WP 3.4.
- Fix warnings when saving posts.
- Fix footer scripts setting having incorrect ID.
- Fix extra quote in Author Box setting markup.
- Fix empty post image link, when there is no post image.
- Fix empty featured post / page widget image link, when there is no image to display.
- Fix use of path constants in post-templates to use functions instead.
- Fix comments template loading on custom post type single posts, if it supports comments.
- Fix post class field not saving.
- Fix inconsistency with comments and trackback edit links.
- Fix robots meta tag help links to point to articles by Yoast.
- Fix dropdown size issue in widget forms.
- Fix trackback URL output showing when post type does not support trackbacks.
- Fix post meta section showing for pages in search results page.
- Fix grid loop problems.
- Fix spacing between bottom buttons on settings pages.

### Security
- Improve sanitization on some settings inputs.
- Improve search form security by escaping input and button text outside of filter – you should remove any `esc_attr()` calls in functions that filter these strings and just return plain text.
- Add a new sanitization filter, `url`.
- Add escaping to names and dimensions of image sizes used in image size dropdowns.
