<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Contributors
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Value object representing a single contributor to Genesis.
 *
 * @since 2.5.0
 *
 * @package Genesis\Contributors
 */
final class Genesis_Contributor {
	/**
	 * Name of contributor.
	 *
	 * @var string
	 */
	private $name;

	/**
	 * URL to contributors profile.
	 *
	 * @var string
	 */
	private $profile_url;

	/**
	 * URL to contributor's avatar.
	 *
	 * @var string
	 */
	private $avatar_url;

	/**
	 * Role in current release.
	 *
	 * @var string
	 */
	private $role;

	/**
	 * Initialize fields in Genesis_Contributor instance.
	 *
	 * @since 2.5.0
	 *
	 * @param string $name        Name of contributor.
	 * @param string $profile_url URL to contributor's profile.
	 * @param string $avatar_url  URL to contributor's avatar.
	 * @param string $role        Role of contributor in current release.
	 */
	public function __construct( $name, $profile_url, $avatar_url, $role ) {
		$this->name        = $name;
		$this->profile_url = $profile_url;
		$this->avatar_url  = $avatar_url;
		$this->role        = $role;
	}

	/**
	 * Get contributors name.
	 *
	 * @since 2.5.0
	 *
	 * @return string Contributor's name.
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Get contributors profile URL.
	 *
	 * @since 2.5.0
	 *
	 * @return string Contributor's profile URL.
	 */
	public function get_profile_url() {
		return $this->profile_url;
	}

	/**
	 * Get contributors avatar URL.
	 *
	 * @since 2.5.0
	 *
	 * @return string Contributor's avatar URL.
	 */
	public function get_avatar_url() {
		return $this->avatar_url;
	}

	/**
	 * Get contributors role.
	 *
	 * @since 2.5.0
	 *
	 * @return string Contributor's role.
	 */
	public function get_role() {
		return $this->role;
	}

	/**
	 * Get contributors role as translatable name.
	 *
	 * @since 2.5.0
	 *
	 * @return string Contributor's role.
	 */
	public function get_named_role() {
		$roles = array(
			'contributor'    => __( 'Contributor', 'genesis' ),
			'lead-developer' => __( 'Lead Developer', 'genesis' ),
		);

		if ( isset( $roles[ $this->role ] ) ) {
			return $roles[ $this->role ];
		}

		return '';
	}
}
