<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<table class="form-table">
<tbody>

	<?php if ( genesis_html5() && $this->get_field_value( 'semantic_headings' ) ) : ?>
	<tr valign="top">
		<th scope="row"><?php _e( 'Section Headings', 'genesis' ); ?></th>
		<td>
			<p><span class="description"><?php _e( 'This setting has been deprecated because it is no longer recommended. If you uncheck this box, the setting will disappear.', 'genesis' ); ?></span></p>
			<p>
				<label for="<?php $this->field_id( 'semantic_headings' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'semantic_headings' ); ?>" id="<?php $this->field_id( 'semantic_headings' ); ?>" value="1" <?php checked( $this->get_field_value( 'semantic_headings' ) ); ?> />
				<?php _e( 'Use semantic HTML5 page and section headings throughout site?', 'genesis' ); ?></label>
			</p>
		</td>
	</tr>
	<?php endif; ?>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Document Title', 'genesis' ); ?></th>
		<td>
			<p>
				<label for="<?php $this->field_id( 'append_site_title' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'append_site_title' ); ?>" id="<?php $this->field_id( 'append_site_title' ); ?>" value="1" <?php checked( $this->get_field_value( 'append_site_title' ) ); ?> />
				<?php
				/* translators: %s: Escaped title tag. */
				printf( esc_html__( 'Add site name to %s on inner pages?', 'genesis' ), genesis_code( '<title>' ) );
				?> </label>
			</p>

			<p>
				<label for="<?php $this->field_id( 'doctitle_sep' ); ?>"><?php _e( 'Document Title Separator', 'genesis' ); ?></label>
				<input type="text" name="<?php $this->field_name( 'doctitle_sep' ); ?>" class="small-text" id="<?php echo esc_attr( $this->get_field_id( 'doctitle_sep' ) ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'doctitle_sep' ) ); ?>" /><br />
				<span class="description"><?php esc_html_e( 'If the title consists of two parts (original title and optional addition), then the separator will go in between them.', 'genesis' ); ?></span>
			</p>

		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'doctitle_seplocation' ); ?>"><?php esc_html_e( 'Document Title Order', 'genesis' ); ?></label></th>
		<td>
			<select name="<?php $this->field_name( 'doctitle_seplocation' ); ?>" id="<?php $this->field_id( 'doctitle_seplocation' ); ?>">
				<option value="left" <?php selected( $this->get_field_value( 'doctitle_seplocation' ), 'left' ); ?>><?php esc_html_e( 'Additions on left', 'genesis' ); ?></option>
				<option value="right" <?php selected( $this->get_field_value( 'doctitle_seplocation' ), 'right' ); ?>><?php esc_html_e( 'Additions on right', 'genesis' ); ?></option>
			</select>
			<p><span class="description"><?php esc_html_e( 'Determines which side the added title text will go on.', 'genesis' ); ?></span></p>
		</td>
	</tr>

</tbody>
</table>
