<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<h2><?php esc_html_e( 'Author Archive Settings', 'genesis' ); ?></h2>
<p><span class="description"><?php esc_html_e( 'These settings apply to this author\'s archive pages.', 'genesis' ); ?></span></p>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row"><label for="headline"><?php esc_html_e( 'Custom Archive Headline', 'genesis' ); ?></label></th>
			<td>
				<input name="genesis-meta[headline]" id="genesis-meta[headline]" type="text" value="<?php echo esc_attr( get_the_author_meta( 'headline', $object->ID ) ); ?>" class="regular-text" /><br />
				<span class="description">
				<?php
					/* translators: Escaped H1 tag. */
					printf( esc_html__( 'Will display in the %s tag at the top of the first page', 'genesis' ), genesis_code( '<h1>' ) );
				?>
				</span>
			</td>
		</tr>

		<tr>
			<th scope="row"><label for="intro_text"><?php esc_html_e( 'Custom Description Text', 'genesis' ); ?></label></th>
			<td>
				<textarea name="genesis-meta[intro_text]" id="intro_text" rows="5" cols="30"><?php echo esc_textarea( get_the_author_meta( 'intro_text', $object->ID ) ); ?></textarea><br />
				<span class="description"><?php esc_html_e( 'This text will be the first paragraph, and display on the first page', 'genesis' ); ?></span>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Author Box', 'genesis' ); ?></th>
			<td>
				<label for="genesis-meta[genesis_author_box_single]"><input id="genesis-meta[genesis_author_box_single]" name="genesis-meta[genesis_author_box_single]" type="checkbox" value="1" <?php checked( get_the_author_meta( 'genesis_author_box_single', $object->ID ) ); ?> />
				<?php esc_html_e( 'Enable Author Box on this User\'s Posts?', 'genesis' ); ?></label><br />

				<label for="genesis-meta[genesis_author_box_archive]"><input id="genesis-meta[genesis_author_box_archive]" name="genesis-meta[genesis_author_box_archive]" type="checkbox" value="1" <?php checked( get_the_author_meta( 'genesis_author_box_archive', $object->ID ) ); ?> />
				<?php esc_html_e( 'Enable Author Box on this User\'s Archives?', 'genesis' ); ?></label>
			</td>
		</tr>
	</tbody>
</table>
