<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

add_action( 'wp_ajax_genesis_do_onboarding_process', 'genesis_do_onboarding_process' );
/**
 * Processes onboarding tasks in batches.
 *
 * @since 2.8.0
 */
function genesis_do_onboarding_process() {

	check_ajax_referer( 'genesis-onboarding', 'nonce' );

	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	$task             = isset( $_POST['task'] ) ? sanitize_key( $_POST['task'] ) : 'dependencies';
	$step             = isset( $_POST['step'] ) ? absint( $_POST['step'] ) : 0;
	$next_step        = $step;
	$percent_complete = 0;
	$complete         = false;
	$errors           = array();

	/**
	 * Install plugin dependencies.
	 */
	if ( 'dependencies' === $task ) {

		require_once ABSPATH . 'wp-admin/includes/plugin-install.php';

		require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';

		$upgrader = new Plugin_Upgrader( new Genesis_Silent_Upgrader_Skin() );

		$existing_plugins         = get_plugins();
		$onboarding_plugins       = genesis_onboarding_plugins();
		$total_onboarding_plugins = count( $onboarding_plugins );

		if ( $total_onboarding_plugins === $step ) {
			wp_send_json_success(
				array(
					'task'             => 'dependencies',
					'percent_complete' => 100,
					'next_step'        => 0,
					'complete'         => true,
					'errors'           => $errors,
				)
			);
		}

		$onboarding_plugin = $onboarding_plugins[ $step ];

		if ( ! array_key_exists( $onboarding_plugin['slug'], $existing_plugins ) ) {

			remove_action( 'upgrader_process_complete', array( 'Language_Pack_Upgrader', 'async_upgrade' ), 20 );

			add_action( 'upgrader_process_complete', 'genesis_onboarding_install_language_packs', 20 );

			$short_slug = strtok( $onboarding_plugin['slug'], DIRECTORY_SEPARATOR );

			$api = plugins_api( 'plugin_information', array( 'slug' => $short_slug ) );

			if ( is_wp_error( $api ) ) {
				$errors[] = $api->get_error_message();
				$next_step++;
				wp_send_json_success(
					array(
						'percent_complete' => $percent_complete,
						'next_step'        => $next_step,
						'task'             => $task,
						'complete'         => $complete,
						'errors'           => $errors,
					)
				);
			}

			$installed = $upgrader->install( $api->download_link );

			if ( is_wp_error( $installed ) ) {
				$errors[] = $installed->get_error_message();
			}
		}

		activate_plugin( $onboarding_plugin['slug'], false, false, true );

		$step++;

		$percent_complete = round( ( $step / $total_onboarding_plugins ) * 100, 2 );

		$next_step++;

		if ( $total_onboarding_plugins === $step ) {
			$percent_complete = 100;
			$next_step        = 0;
			$complete         = true;
		}

		wp_send_json_success(
			array(
				'percent_complete' => $percent_complete,
				'task'             => 'dependencies',
				'next_step'        => $next_step,
				'complete'         => $complete,
				'errors'           => $errors,
			)
		);
	}

	/**
	 * Import demo content.
	 */
	if ( 'content' === $task ) {

		$content = genesis_onboarding_content();

		$homepage_edit_link = false;

		if ( ! empty( $content ) ) {

			foreach ( $content as $key => $post ) {

				$post_id = wp_insert_post(
					array(
						'post_content'   => $post['post_content'],
						'post_status'    => $post['post_status'],
						'post_title'     => $post['post_title'],
						'post_name'      => $post['post_name'],
						'post_type'      => $post['post_type'],
						'comment_status' => $post['comment_status'],
					)
				);

				if ( is_wp_error( $post_id ) ) {
					/* translators: 1: Title of the page, 2: The error message. */
					$errors[] = sprintf( esc_html__( 'There was an error importing the %1$s page. Error: %2$s', 'genesis' ), $post['post_title'], $post_id->get_error_message() );
					continue;
				}

				if ( 'homepage' === $key ) {
					update_option( 'show_on_front', 'page' );
					update_option( 'page_on_front', $post_id );
					$homepage_edit_link = esc_url_raw( admin_url( 'post.php?action=edit&post=' . $post_id ) );
				}

				if ( ! empty( $post['page_template'] ) ) {
					update_post_meta( $post_id, '_wp_page_template', sanitize_text_field( $post['page_template'] ) );
				}
			}
		}

		wp_send_json_success(
			array(
				'percent_complete'   => 100,
				'task'               => 'content',
				'next_step'          => 0,
				'complete'           => true,
				'homepage_edit_link' => $homepage_edit_link,
				'errors'             => $errors,
			)
		);
	}

	/**
	 * Send a default response in the unlikely event we reach this.
	 */
	wp_send_json_success(
		array(
			'percent_complete' => 100,
			'task'             => $task,
			'next_step'        => $next_step,
			'complete'         => true,
			'errors'           => $errors,
		)
	);
}
