<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Returns an array of onboarding plugins provided by Genesis or the child theme.
 *
 * @since 2.8.0
 *
 * @return array
 */
function genesis_onboarding_plugins() {

	$config_file = locate_template( '/config/onboarding.php' );

	if ( ! is_readable( $config_file ) ) {
		return array();
	}

	$config = require $config_file;

	return isset( $config['dependencies']['plugins'] ) ? $config['dependencies']['plugins'] : array();
}

/**
 * Returns an array of onboarding content provided by Genesis or the child theme.
 *
 * @since 2.8.0
 *
 * @return array
 */
function genesis_onboarding_content() {

	$config_file = locate_template( '/config/onboarding.php' );

	if ( ! is_readable( $config_file ) ) {
		return array();
	}

	$config = require $config_file;

	return isset( $config['content'] ) ? $config['content'] : array();
}

/**
 * Installs plugin language packs during the onboarding process.
 *
 * Hooked to the 'upgrader_process_complete' action.
 *
 * @since 2.8.0
 */
function genesis_onboarding_install_language_packs() {

	$language_updates = wp_get_translation_updates();

	if ( empty( $language_updates ) ) {
		return;
	}

	$lp_upgrader = new Language_Pack_Upgrader( new Genesis_Silent_Upgrader_Skin() );
	$lp_upgrader->bulk_upgrade( $language_updates );
}
