<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<table class="form-table">
<tbody>
	<?php if ( ! genesis_html5() || ! $this->get_field_value( 'semantic_headings' ) ) : ?>
	<tr valign="top" <?php echo genesis_html5() ? 'id="genesis_seo_h1_wrap"' : '';?>>
		<th scope="row">
			<?php
			/* translators: Escaped H1 tag. */
			printf( esc_html__( 'Primary Title %s', 'genesis' ), genesis_code( 'h1' ) );
			?>
		</th>
		<td>
			<fieldset>
				<legend class="screen-reader-text">
					<?php
					/* translators: Escaped H1 tag. */
					printf( esc_html__( 'Primary Title %s', 'genesis' ), genesis_code( 'h1' ) );
					?>
				</legend>
				<p>
					<input type="radio" name="<?php $this->field_name( 'home_h1_on' ); ?>" id="<?php $this->field_id( 'home_h1_on_title' ); ?>" value="title" <?php checked( $this->get_field_value( 'home_h1_on' ), 'title' ); ?> />
					<label for="<?php $this->field_id( 'home_h1_on_title' ); ?>"><?php esc_html_e( 'Site Title', 'genesis' ); ?></label>
					<br />
					<input type="radio" name="<?php $this->field_name( 'home_h1_on' ); ?>" id="<?php $this->field_id( 'home_h1_on_description' ); ?>" value="description" <?php checked( $this->get_field_value( 'home_h1_on' ), 'description' ); ?> />
					<label for="<?php $this->field_id( 'home_h1_on_description' ); ?>"><?php esc_html_e( 'Site Description (Tagline)', 'genesis' ); ?></label>
					<br />
					<input type="radio" name="<?php $this->field_name( 'home_h1_on' ); ?>" id="<?php $this->field_id( 'home_h1_on_neither' ); ?>" value="neither" <?php checked( $this->get_field_value( 'home_h1_on' ), 'neither' ); ?> />
					<label for="<?php $this->field_id( 'home_h1_on_neither' ); ?>"><?php esc_html_e( 'I\'ll manually wrap my own text on the homepage', 'genesis' ); ?></label>
				</p>
			</fieldset>
		</td>
	</tr>
	<?php endif; ?>
	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'home_doctitle' ); ?>"><?php esc_html_e( 'Document Title', 'genesis' ); ?></label></th>
		<td>
			<p>
				<input type="text" name="<?php $this->field_name( 'home_doctitle' ); ?>" class="large-text" id="<?php $this->field_id( 'home_doctitle' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'home_doctitle' ) ); ?>" /><br />
				<span class="description"><?php esc_html_e( 'If you leave the document title field blank, your site&#8217;s title will be used instead.', 'genesis' ); ?></span>
			</p>

			<p>
				<label for="<?php $this->field_id( 'append_description_home' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'append_description_home' ); ?>" id="<?php $this->field_id( 'append_description_home' ); ?>" value="1" <?php checked( $this->get_field_value( 'append_description_home' ) ); ?> />
				<?php
					/* translators: Escaped title tag. */
					printf( esc_html__( 'Add site description (tagline) to %s on home page?', 'genesis' ), genesis_code( '<title>' ) );
				?>
				</label>
			</p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'home_description' ); ?>"><?php esc_html_e( 'Meta Description', 'genesis' ); ?></label></th>
		<td>
			<p>
				<textarea name="<?php $this->field_name( 'home_description' ); ?>" class="large-text" id="<?php $this->field_id( 'home_description' ); ?>" rows="3" cols="70"><?php echo esc_textarea( $this->get_field_value( 'home_description' ) ); ?></textarea><br />
				<span class="description"><?php esc_html_e( 'The meta description can be used to determine the text used under the title on search engine results pages.', 'genesis' ); ?></span>
			</p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'home_keywords' ); ?>"><?php esc_html_e( 'Meta Keywords', 'genesis' ); ?></label></th>
		<td>
			<p>
				<input type="text" name="<?php $this->field_name( 'home_keywords' ); ?>" class="large-text" id="<?php $this->field_id( 'home_keywords' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'home_keywords' ) ); ?>" /><br />
				<span class="description"><?php esc_html_e( 'Keywords are generally ignored by Search Engines.', 'genesis' ); ?></span>
			</p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Robots Meta Tags', 'genesis' ); ?></th>
		<td>
			<p>
				<label for="<?php $this->field_id( 'home_noindex' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'home_noindex' ); ?>" id="<?php $this->field_id( 'home_noindex' ); ?>" value="1" <?php checked( $this->get_field_value( 'home_noindex' ) ); ?> />
				<?php
					/* translators: Meta noindex attribute. */
					printf( esc_html__( 'Apply %s to the homepage?', 'genesis' ), genesis_code( 'noindex' ) );
				?>
				</label>
				<br />
				<label for="<?php $this->field_id( 'home_nofollow' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'home_nofollow' ); ?>" id="<?php $this->field_id( 'home_nofollow' ); ?>" value="1" <?php checked( $this->get_field_value( 'home_nofollow' ) ); ?> />
				<?php
					/* translators: Meta nofollow attribute. */
					printf( esc_html__( 'Apply %s to the homepage?', 'genesis' ), genesis_code( 'nofollow' ) );
				?>
				</label>
				<br />
				<label for="<?php $this->field_id( 'home_noarchive' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'home_noarchive' ); ?>" id="<?php $this->field_id( 'home_noarchive' ); ?>" value="1" <?php checked( $this->get_field_value( 'home_noarchive' ) ); ?> />
				<?php
					/* translators: Meta noarchive attribute. */
					printf( esc_html__( 'Apply %s to the homepage?', 'genesis' ), genesis_code( 'noarchive' ) );
				?>
				</label>
			</p>
		</td>
	</tr>

</tbody>
</table>
