<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0+
 * @link    http://my.studiopress.com/themes/genesis/
 */

?>
<table class="form-table">
<tbody>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Enable Comments', 'genesis' ); ?></th>
		<td>
		<fieldset>
			<legend class="screen-reader-text"><?php esc_html_e( 'Enable Comments', 'genesis' ); ?></legend>

			<p><label for="<?php $this->field_id( 'comments_posts' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'comments_posts' ); ?>" id="<?php $this->field_id( 'comments_posts' ); ?>" value="1"<?php checked( $this->get_field_value( 'comments_posts' ) ); ?> />
			<?php esc_html_e( 'on posts?', 'genesis' ); ?></label></p>

			<p><label for="<?php $this->field_id( 'comments_pages' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'comments_pages' ); ?>" id="<?php $this->field_id( 'comments_pages' ); ?>" value="1"<?php checked( $this->get_field_value( 'comments_pages' ) ); ?> />
			<?php esc_html_e( 'on pages?', 'genesis' ); ?></label></p>

		</fieldset>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Enable Trackbacks', 'genesis' ); ?></th>
		<td>
		<fieldset>
			<legend class="screen-reader-text"><?php esc_html_e( 'Enable Trackbacks', 'genesis' ); ?></legend>

			<p><label for="<?php $this->field_id( 'trackbacks_posts' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'trackbacks_posts' ); ?>" id="<?php $this->field_id( 'trackbacks_posts' ); ?>" value="1"<?php checked( $this->get_field_value( 'trackbacks_posts' ) ); ?> />
			<?php esc_html_e( 'on posts?', 'genesis' ); ?></label></p>

			<p><label for="<?php $this->field_id( 'trackbacks_pages' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'trackbacks_pages' ); ?>" id="<?php $this->field_id( 'trackbacks_pages' ); ?>" value="1"<?php checked( $this->get_field_value( 'trackbacks_pages' ) ); ?> />
			<?php esc_html_e( 'on pages?', 'genesis' ); ?></label></p>

		</fieldset>
		</td>
	</tr>

</tbody>
</table>
