<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Register meta boxes added to WordPress admin screens.
 *
 * @package Genesis\Admin
 */
class Genesis_Admin_Meta_Boxes extends Genesis_Admin_Boxes {

	/**
	 * Create a meta box handler.
	 *
	 * @since 2.5.0
	 */
	public function __construct() {

		$this->help_base  = GENESIS_VIEWS_DIR . '/help/';
		$this->views_base = GENESIS_VIEWS_DIR;

	}

	/**
	 * Bypass registering meta boxes.
	 *
	 * @since 2.5.0
	 */
	public function metaboxes() {}

	/**
	 * Echo out the content of a meta box.
	 *
	 * @since 2.5.0
	 *
	 * @param string $id     Id of the meta box.
	 * @param object $object Object for the meta box. Default null.
	 */
	public function show_meta_box( $id, $object = null ) {

		$this->do_meta_box(
			$object, array(
				'id' => $id,
			)
		);

	}
}
