<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<p><span class="description"><?php esc_html_e( 'These settings apply to any page given the "Blog" page template, not the homepage or post archive pages.', 'genesis' ); ?></span></p>
<table class="form-table">
<tbody>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Display Category', 'genesis' ); ?></th>
		<td>
			<p><label for="<?php $this->field_id( 'blog_cat' ); ?>" class="screen-reader-text"><?php esc_html_e( 'Display which category', 'genesis' ); ?></label>
			<?php wp_dropdown_categories( array(
	'selected' => $this->get_field_value( 'blog_cat' ),
	'name' => $this->get_field_name( 'blog_cat' ),
	'orderby' => 'Name',
	'hierarchical' => 1,
	'show_option_all' => __( 'All Categories', 'genesis' ),
	'hide_empty' => '0',
) ); ?></p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'blog_cat_exclude' ); ?>"><?php esc_html_e( 'Exclude Categories', 'genesis' ); ?></label></th>
		<td>
			<p>
			<input type="text" name="<?php $this->field_name( 'blog_cat_exclude' ); ?>" class="regular-text" id="<?php $this->field_id( 'blog_cat_exclude' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'blog_cat_exclude' ) ); ?>" />
			<br /><small><strong><?php esc_html_e( 'Category IDs, comma separated - 1,2,3 for example', 'genesis' ); ?></strong></small>
			</p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'blog_cat_num' ); ?>"><?php esc_html_e( 'Posts per Page', 'genesis' ); ?></label></th>
		<td>
			<input type="text" name="<?php $this->field_name( 'blog_cat_num' ); ?>" id="<?php $this->field_id( 'blog_cat_num' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'blog_cat_num' ) ); ?>" size="2" />
		</td>
	</tr>

</tbody>
</table>
